<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class PackageSubscribe extends Model
{
    use HasFactory;
    protected $fillable = ['package_id','user_id','total_price','city_id','model_id','date','time','notes','vendor_id','status'];
    
    public function items(){
        return $this->hasMany(PackageSubscribeItem::class);
    }
         public function package()
    {
        return $this->belongsTo(Package::class,'package_id');
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'city_id');
    }
       public function model()
    {
        return $this->belongsTo(CarModel::class, 'model_id');
    }
       public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}