<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'category_id',
        'price',
        'stock',
        'condition',
        'discount_percent',
        'offer_starts_at',
        'offer_ends_at',
        'car_category_id',
        'brand_id',
        'model_id',
        'warranty_period',
        'origin_country',
        'vendor_id',
    ];

    public function images(){
        return $this->hasMany(ProductImage::class);
    }
    public function category(){
        return $this->belongsTo(Category::class,'category_id');
    }
       public function carCategory(){
        return $this->belongsTo(CarCategory::class,'car_category_id');
    }
       public function brand(){
        return $this->belongsTo(Brand::class,'brand_id');
    }
       public function model(){
        return $this->belongsTo(CarModel::class,'model_id');
    }
      public function vendor(){
        return $this->belongsTo(Vendor::class,'vendor_id');
    }
    

   
}