<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class Provider extends Authenticatable
{
     use HasApiTokens, Notifiable;

    protected $fillable = [
        'name', 'email', 'password', 'address', 'city_id','fcm_token'
    ];

    protected $hidden = [
        'password', 'remember_token',
    ];

    public function city()
    {
        return $this->belongsTo(City::class);
    }

  

    public function categories()
    {
        return $this->belongsToMany(Category::class, 'category_provider');
    }
}
