<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Translatable\HasTranslations;

class RepairIssue extends Model
{
    use HasFactory,HasTranslations;

    protected $table = 'repair_issues';

    protected $fillable = [
        'title',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
    public $translatable = ['title'];

    public function vendors()
    {
        return $this->belongsToMany(Vendor::class, 'vendor_repair_issue')
            ->withTimestamps();
    }

    public function inspections()
    {
        return $this->hasMany(Inspection::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}