<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SparePart extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    protected $fillable = [
        'name',
        'description',
        'price',
        'copy_price',
        'image',
        'vendor_id',
        'model_id',
        'category_id',
        'condition',
        'discount_percent',
        'offer_starts_at',
        'offer_ends_at',
        'car_category_id',
        'city_id',
        'stock',
        'warranty_period',
        'origin_country',
        'capacity_ah',       // For Batteries
        'width',             // For Batteries and Rims
        'aspect_ratio',      // For Tires
        'diameter',          // For Tires and Rims
        'viscosity',         // For Oils
        'weight',            // For Oils
        'centre_bore',       // For Rims
        'bolt_pattern',      // For Rims
        'brand_id',         // For Accessories and New/Used Parts
        'is_new',
        'is_active',
        'barcode',
    ];

    public $translatable = ['name'];

    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }
/* 
    public function model()
    {
        return $this->belongsTo(CarModel::class);
    } */
  public function models()
    {
        return $this->belongsToMany(
            CarModel::class,
            'sparepart_model',
            'spare_part_id',   // FK في pivot
            'car_model_id',    // FK في pivot
            'id',              // Local key في spare_parts
            'id'               // Local key في models
        )
        ->withPivot('id')
        ->withTimestamps();
    }


    public function category()
    {
        return $this->belongsTo(Category::class);
    }
     public function brand()
    {
        return $this->belongsTo(Brand::class,'brand_id');
    }


    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function cartItems()
    {
        return $this->hasMany(CartItem::class);
    }

    public function orderItems()
    {
        return $this->hasMany(OrderItem::class);
    }
     public function images(){
        return $this->hasMany(ProductImage::class,'product_id');
    }
    public function filters(){
        return $this->hasMany(SparePartFilter::class,'spare_part_id');
    }
}     