<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;


class SparePartOffer extends Model
{
    use HasFactory;
  
    protected $table = 'spare_part_offers';

    
    protected $fillable = [
        'item_id',
        'vendor_id',
        'price',
        'warranty_period',
        'status',
    ];

   
    protected $casts = [
        'price' => 'decimal:2',
        'warranty_period' => 'string',
        'status' => 'string',
    ];

    
    public function requestitem()
    {
        return $this->belongsTo(CustomPartRequestItem::class,'item_id');
    }

   
    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }

 
    public function files(): HasMany
    {
        return $this->hasMany(SparePartOfferFile::class);
    }
     public function payments(): HasMany
    {
        return $this->hasMany(SparePartOfferPayment::class);
    }

    public function getPaidAmountAttribute()
    {
        if ($this->status !== 'accepted') {
            return 0;
        }

        return $this->payments()->sum('amount');
    }

    public function getRemainingAmountAttribute()
    {
        if ($this->status !== 'accepted') {
            return $this->price;
        }

        return $this->price - $this->paid_amount;
    }


}
