<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes;

    protected $fillable = [
        'full_name',
        'phone',
        'email',
        'password',
        'city_id',
        'email_verified',
        'email_verification_code',
        'image',
        'fcm_token'
    ];


    public function carsForSale()
    {
        return $this->hasMany(CarForSale::class);
    }

    public function customPartRequests()
    {
        return $this->hasMany(CustomPartRequest::class);
    }
    protected $hidden = ['password', 'email_verification_code'];

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function carts()
    {
        return $this->hasMany(Cart::class);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function towRequests()
    {
        return $this->hasMany(TowRequest::class);
    }

    public function userCars()
    {
        return $this->hasMany(UserCar::class);
    }

    public function notifications()
    {
        return $this->hasMany(Notification::class,'user_id');
    }
    public function wenches(){
        return $this->hasMany(Winch::class,'user_id');
    }
}