<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserCar extends Model
{
    use HasFactory, SoftDeletes, Notifiable;

    protected $fillable = [
        'model_id',
        'manufacturing_year',
        'engine_id',
        'chassis_number',
        'chassis_image',
        'car_image',
        'name',
        'description',
        'user_id'
    ];

    // public function model()
    // {
    //     return $this->belongsTo(CarModel::class);
    // }
    public function carModel()
    {
        return $this->belongsTo(CarModel::class, 'model_id');
    }
      public function engine()
    {
        return $this->belongsTo(CarEngine::class, 'engine_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}