<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Relations\HasMany;


class Vendor extends Authenticatable
{
    use HasFactory, SoftDeletes, Notifiable, HasTranslations,HasApiTokens;

    protected $fillable = [
        'name',
        'email',
        'phone',
        'password',
        'city_id',
        'address',
        'image',
        'description',
        'is_active',
        'type',
        'fcm_token'
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];
    public $translatable = ['name'];

    protected $hidden = ['password'];

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function spareParts()
    {
        return $this->hasMany(SparePart::class);
    }

    public function carsForSale()
    {
        return $this->hasMany(CarForSale::class);
    }

    public function customPartRequests()
    {
        return $this->hasMany(CustomPartRequest::class);
    }

    public function timetables()
    {
        return $this->hasMany(VendorTimetable::class);
    }
        public function appointments()
    {
        return $this->hasMany(Appointment::class,'vendor_id');
    }

  /*   public function repairIssues()
    {
        return $this->hasMany(VendorRepairIssue::class);
           
    } */

    public function inspections()
        {
            return $this->belongsToMany(
                Inspection::class,      
                'vendor_inspection',     
                'vendor_id',             
                'inspection_id'          
            );
        }
    public function brands()
    {
        return $this->belongsToMany(Brand::class, 'brand_vendor')->withTimestamps();
    }
      public function categories()
    {
        return $this->belongsToMany(Category::class, 'category_provider');
    }

    // Custom method to mimic getTranslation for JSON name field

    public function sparePartOffers()
    {
        return $this->hasMany(SparePartOffer::class);
    }
    public function products(): HasMany
    {
        return $this->hasMany(SparePart::class, 'vendor_id');
    }
    
    public function wallet()
    {
        return $this->hasOne(Wallet::class);
    }
    public function notification(){
        return $this->hasMany(Notification::class,'vendor_id');
    }

}