<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Wallet extends Model
{
    use HasFactory;
     protected $fillable = [
        'vendor_id',
        'spare_parts_count',
        'spare_parts_total_price',
        'product_count',
        'product_total_price',
    ];

    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }

    public function getTotalSalesCountAttribute()
    {
        return $this->spare_parts_count + $this->product_count;
    }

    public function getTotalSalesAmountAttribute()
    {
        return $this->spare_parts_total_price + $this->product_total_price;
    }
}
