<?php

namespace App\Observers;

use App\Models\CarForSale;
use App\Models\Admin;
use App\Mail\EventDataMail;
use Illuminate\Support\Facades\Mail;

class CarForSaleObserver
{
    public function created(CarForSale $car)
    {
        
        $admins = Admin::role('ادارة سوق السيارات')->get(); // Spatie Roles

        $data = [
            'subject' => 'تم إضافة سيارة جديدة في السوق',
            'content' => 'تم إضافة سيارة جديدة باسم: ' . ($car->title ?? $car->id),
            'extra'   => 'يمكنك مراجعة السيارة عبر لوحة التحكم.',
        ];

        foreach ($admins as $admin) {
            Mail::to($admin->email)->queue(new EventDataMail($data));
        }
    }
}
