<?php
namespace App\Observers;
use App\Models\Admin;
use App\Models\SparePart;
use App\Mail\EventDataMail;
use Illuminate\Support\Facades\Mail;

class SparePartObserver
{
    public function created(SparePart $sparpart)
    {
        $category = $sparpart->category;

        if ($category && $category->active == 0) {
            $category->update(['active' => 1]);
        }


        if ( request()->routeIs('admin.products.store')) {
            return;
        }

        $admins = Admin::permission('ادارة المنتجات')->get(); // Assuming Spatie Roles

                $data = [
                    'subject' => 'تم إضافة منتج جديد',
                    'content' => 'تم إضافة منتج جديد باسم: ' . $sparpart->getTranslation('name','ar'),
                    'extra'   => 'يمكنك مراجعة المنتج عبر لوحة التحكم.',
                ];

        foreach ($admins as $admin) {
                    Mail::to($admin->email)->send(new EventDataMail($data));
         }



    }

    public function deleted(SparePart $sparpart)
    {
        $category = $sparpart->category;

        if ($category && $category->spareParts()->count() === 0) {
            $category->update(['active' => 0]);
        }
    }
}