<?php

namespace App\Observers;

use App\Models\Wench;
use App\Models\Admin;
use App\Mail\EventDataMail;
use Illuminate\Support\Facades\Mail;
class WenchObserver
{
    /**
     * Handle the Wench "created" event.
     */
   
         public function created(SparePart $sparpart)
    {
        $category = $sparpart->category;

        if ($category && $category->active == 0) {
            $category->update(['active' => 1]);
        }


        if ( request()->routeIs('admin.products.store')) {
            return;
        }

        $admins = Admin::permission('ادارة طلبات الونش')->get(); // Assuming Spatie Roles

                $data = [
                    'subject' => 'تم إضافة طلب ونش جديد',
                    'content' => 'تم إضافة طلب ونش جديد : ' ,
                    'extra'   => 'يمكنك مراجعة الطلبات عبر لوحة التحكم.',
                ];

        foreach ($admins as $admin) {
                    Mail::to($admin->email)->send(new EventDataMail($data));
         }



  
    }

    /**
     * Handle the Wench "updated" event.
     */
    public function updated(Wench $wench): void
    {
        //
    }

    /**
     * Handle the Wench "deleted" event.
     */
    public function deleted(Wench $wench): void
    {
        //
    }

    /**
     * Handle the Wench "restored" event.
     */
    public function restored(Wench $wench): void
    {
        //
    }

    /**
     * Handle the Wench "force deleted" event.
     */
    public function forceDeleted(Wench $wench): void
    {
        //
    }
}
