<?php
namespace App\Services;

use Kreait\Firebase\Contract\Messaging;
use Kreait\Firebase\Messaging\CloudMessage;
use Illuminate\Support\Facades\Log;
use Kreait\Firebase\Factory;

class FirebaseNotificationService
{
    protected $messaging;

    public function __construct(Messaging $messaging)
    {
        $this->messaging = $messaging;
    }
    public static function fromJson(string $firebaseJsonPath): self
    {
        $factory = (new Factory)->withServiceAccount($firebaseJsonPath);
        $messaging = $factory->createMessaging();

        return new self($messaging);
    }

    /**
     * Send a push notification to a user  
     *
     * @param \App\Models\User $user
     * @param string $title
     * @param string $body
     * @param array $data
     * @return bool
     */
    public function sendNotification($user, $title, $body, $data = [])
    {
       
        if (!$user->fcm_token) {
            Log::warning("No device token found for user ID: {$user->id}");
            return false;
        }

        $message = CloudMessage::withTarget('token', $user->fcm_token)
            ->withNotification([
                'title' => $title,
                'body' => $body,
            ])
            ->withData($data);

        try {
            $this->messaging->send($message);
            Log::info("Notification sent to user ID: {$user->id}");
            return true;
        } catch (\Exception $e) {
            Log::error("Failed to send notification to user ID: {$user->id}", ['error' => $e->getMessage()]);
            return false;
        }
    }
}