<?php

namespace App\Services;

use App\Models\CarModel;
use App\Models\Vendor;
use App\Notifications\NewCustomPartRequestNotification;
use App\Services\FirebaseNotificationService;
use App\Services\CustomFirebaseServive;
use App\Models\User;
use App\Models\SparePartOffer;

class UserNotificationService
{
    protected FirebaseNotificationService $firebaseService;

    public function __construct()
    {
        $this->firebaseService = FirebaseNotificationService::fromJson(storage_path('app/serviceAccountKey.json'));
    }

    /**
     * Notify vendors in same city and brand of a model
     */
    public function notifyaddoffer($user_id, $offer_id, $message = null): void
    {
      

        $user = User::find($user_id);
           
         $offer= \App\Models\SparePartOffer::find($offer_id);

        $notificationService = new CustomFirebaseServive();

       
        
           $dd= $notificationService->send(
                null,$user->id,
                'تم اضافة عرض جديد علي جزء مخصص من الطلب',
                $message ??   'تم إنشاء عرض جديد لتسعير قطع الغيار المطلوبة لديك من قبل ' .  $offer->vendor->name .' بقيمة  '  .  $offer->price . '  ج.م' ,
                'offer_request',
                $offer_id,
                \App\Models\SparePartOffer::class,
                'waiting',
            );

            // Send via Firebase push
            $this->firebaseService->sendNotification(
                $user,
                'عرض جديد علي طلب قطع الغيار',
                $message ?? 'تم إنشاء عرض جديد لطلب قطع الغيار.',
                ['offer_request_id' => (string)$offer_id]
            );
        
    }
    public function requestChangeStatus($user_id, $request_id, $status, $message = null): void
    {
        $user = User::find($user_id);

        $request = \App\Models\CustomPartRequest::find($request_id);

        $notificationService = new CustomFirebaseServive();

        $statusText = match ($status) {
            'prepared'   => 'تم التجهيز',
            'shipped'  => 'تم التوصيل ',
            'ended'  => 'تم التسليم',
            'completed' => 'تم الاكتمال',
            default     => ucfirst($status),
        };

        $title   = 'تحديث حالة طلبك لقطع الغيار';
        $body    = $message 
            ?? 'تم تحديث حالة طلبك رقم ' . $request->id . 
            ' إلى الحالة: ' . $statusText . 
            ' بقيمة ' . $request->total_price . ' ج.م';

        // حفظ في قاعدة البيانات (Notifications)
        $notificationService->send(
            null,
            $user->id,
            $title,
            $body,
            'custome_request',
            $request_id,
            \App\Models\CustomPartRequest::class,
            'completed'
        );

        // إرسال إشعار Push عبر Firebase
        $this->firebaseService->sendNotification(
            $user,
            $title,
            $body,
            [
                'offer_request_id' => (string)$request_id,
                'status'           => $status
            ]
        );
    }
      public function orderChangeStatus($user_id, $order_id, $status, $message = null): void
    {
        $user = User::find($user_id);

        $request = \App\Models\Order::find($order_id);

        $notificationService = new CustomFirebaseServive();

        $statusText = match ($status) {
            'shipped'  => 'تم التوصيل ',
            'delivered'  => 'تم التسليم',
            default     => ucfirst($status),
        };

        $title   = 'تحديث حالة طلبك  من المنتجات';
        $body    = $message 
            ?? 'تم تحديث حالة طلبك رقم ' . $request->id . 
            ' إلى الحالة: ' . $statusText ;

        // حفظ في قاعدة البيانات (Notifications)
        $notificationService->send(
            null,
            $user->id,
            $title,
            $body,
            'order',
            $order_id,
            \App\Models\Order::class,
            $status
        );

        // إرسال إشعار Push عبر Firebase
        $this->firebaseService->sendNotification(
            $user,
            $title,
            $body,
            [
                'offer_request_id' => (string)$order_id,
                'status'           => $status
            ]
        );
    }

     public function notifyGoogelLogin($user_id, $message = null): void
    {
      

        $user = User::find($user_id);
           

        $notificationService = new CustomFirebaseServive();

       
        
           $dd= $notificationService->send(
                null,$user->id,
                'اهلا بك في Part Mart',
                $message ?? '  لتستمتع بجربة مستخدم متميزة يجب عليك عليك اكمال بياناتك من خلال الملف الشخصي .',
                'offer_request',
                $user_id,
                \App\Models\User::class,
                'waiting',
            );

            // Send via Firebase push
            $this->firebaseService->sendNotification(
                $user,
                'اهلا بك في Part Mart',
                $message ?? '  لتستمتع بجربة مستخدم متميزة يجب عليك عليك اكمال بياناتك من خلال الملف الشخصي .',
               
            );
        
    }
}

         