<?php

namespace App\Services;

use App\Models\CarModel;
use App\Models\Vendor;
use App\Notifications\NewCustomPartRequestNotification;
use App\Services\FirebaseNotificationService;
use App\Services\CustomFirebaseServive;

class VendorNotificationService
{
    protected FirebaseNotificationService $firebaseService;

    public function __construct()
    {
        $this->firebaseService = FirebaseNotificationService::fromJson(storage_path('firebase/custom.json'));
    }

    /**
     * Notify vendors in same city and brand of a model
     */
    public function notifyVendorsByCityAndBrand($cityId, $modelId, $customPartRequestId, $message = null): void
    {
        $model = CarModel::find($modelId);
        if (!$model || !$model->brand_id) {
            return;
        }

        $brandId = $model->brand_id;

        $vendors = Vendor::where('city_id', $cityId)
            ->whereHas('brands', fn($q) => $q->where('brands.id', $brandId))
            ->get();

        $notificationService = new CustomFirebaseServive();

       
        foreach ($vendors as $vendor) {
            $notificationService->send(
                $vendor->id,null,
                'طلب جديد لقطعة غيار',
                $message ?? 'تم إنشاء طلب جديد لقطع الغيار.',
                'custom_part_request',
                $customPartRequestId,
                \App\Models\CustomPartRequest::class
            );

            // Send via Firebase push
            $this->firebaseService->sendNotification(
                $vendor,
                'طلب جديد لقطع الغيار',
                $message ?? 'تم إنشاء طلب جديد لقطع الغيار.',
                ['custom_part_request_id' => (string)$customPartRequestId]
            );
        }
    }

    public function appointmentNotification($appointment_id,$vendor_id){

         $notificationService = new CustomFirebaseServive();
         $notificationService->send(
                $vendor_id,null,
                'تم إنشاء موعيد جديد للصيانة',
                $message ?? 'تم إنشاء موعد  جديد لصيانة السيارات .',
                'appointment',
                $appointment_id,
                \App\Models\Appointment::class
            );
        $vendor=Vendor::find($vendor_id);
        
        $this->firebaseService->sendNotification(
                $vendor,
                'طلب جديد لقطع الغيار',
                $message ?? 'تم إنشاء طلب جديد لقطع الغيار.',
                ['appointment_id' => (string)$appointment_id]
            );


    }
    
    public function acceptOffer($vendor_id,$offer_id){
          $notificationService = new CustomFirebaseServive();
          $notificationService->send(
                $vendor_id,null,
                'تم قبول العرض  الخاص بك',
                $message ?? 'تم قبول العرض الخاص بك لقطعة الغيار المطلوبة .',
                'offer',
                $offer_id,
                \App\Models\SparePartOffer::class
            );
        $vendor=Vendor::find($vendor_id);
        
        $this->firebaseService->sendNotification(
                $vendor,
                'تم قبول العرض  الخاص بك',
                $message ?? 'تم قبول العرض  الخاص بك',
                ['offer_id' => (string)$offer_id]
            );
    }


      public function BookingPackageNotification($appointment_id,$vendor_id){

         $notificationService = new CustomFirebaseServive();
         $notificationService->send(
                $vendor_id,null,
                'تم إنشاء موعيد جديد للصيانة حسب الباقة',
                $message ?? 'تم إنشاء موعد  جديد لصيانة السيارات .',
                'appointment',
                $appointment_id,
                \App\Models\PackageSubscribe::class
            );
        $vendor=Vendor::find($vendor_id);
        
        $this->firebaseService->sendNotification(
                $vendor,
                '   موعد جديد للصيانة الخاصة بالباقات',
                $message ?? 'تم إنشاء موعد جديد للصيانة الخاصة بباقات السيارات.',
                ['subscribe_id' => (string)$appointment_id]
            );


    }
}

