<?php

namespace App\Traits;

use Illuminate\Http\Request;
use App\Models\Product;
trait CategoryTrait
{

    // Validate request inputs
    private function validateProduct(Request $request)
    {
        return $request->validate([
            'name_ar' => 'required|string|max:255',
            'name_en' => 'required|string|max:255',
            'name_url_ar' => 'required|string|max:255',
            'name_url_en' => 'required|string|max:255',
            'details_ar' => 'required|string',
            'details_en' => 'required|string',
            'meta_words' => 'nullable|string',
            'meta_description' => 'nullable|string',
            'alt_title' => 'nullable|string',
            'serail_no' => 'nullable|string',
            'old_price' => 'nullable|integer',
            'current_price' => 'nullable|integer',
            'quantity' => 'nullable|integer',
            'CategoryID' => 'required|exists:categories,id',
            'image' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'images.*' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
        ]);
    }

    // Handle main image upload
    private function handleMainImage(Request $request, $name)
    {
        if ($request->hasFile($name)) {
            return $this->uploadFile('category_images', $request->file($name));
        }
        return null;
    }

    // Handle gallery images upload
    private function handleGalleryImages(Request $request)
    {
        $galleryImages = [];
        if ($request->hasFile('images')) {
            foreach ($request->file('images') as $image) {
                $galleryImages[] = $this->uploadFile('product_gallery', $image);
            }
        }
        return $galleryImages;
    }

    // Create product
    private function createProduct(Request $request, $mainImage, array $galleryImages)
    {
        Product::create([
            'Name' => $this->prepareJsonField($request->name_ar, $request->name_en),
            'name_title' => $this->prepareJsonField($request->name_ar, $request->name_en),
            'image' => $mainImage,
            'details' => $this->prepareJsonField($request->details_ar, $request->details_en),
            'detailsweb' => $this->prepareJsonField($request->detailsweb_ar, $request->detailsweb_en),
            'meta_words' => $request->meta_words,
            'meta_description' => $request->meta_description,
            'alt_title' => $request->alt_title,
            'serail_no' => $request->serail_no,
            'old_price' => $request->old_price,
            'Price' => $request->current_price,
            'StockQuantity' => $request->quantity,
            'CategoryID' => $request->CategoryID,
            'gallery' => null,
        ]);
    }
    private function uploadFile($folder, $file)
    {
        $filename = time() . '-' . $file->getClientOriginalName();
        $file->move(public_path('uploads/' . $folder), $filename);
        return 'uploads/' . $folder . '/' . $filename;
    }
    // Helper to format JSON fields
    private function prepareJsonField($valueAr, $valueEn)
    {
        return json_encode(['ar' => $valueAr, 'en' => $valueEn]);
    }

}