<?php

namespace App\Traits;

use App\Models\User;
use Illuminate\Support\Facades\Auth;
use App\Notifications\NotificationClient;
use Carbon\Carbon;
use App\Models\copon;
use App\Models\Coupon;
use Illuminate\Support\Facades\Validator;

trait CrudTrait
{
    private function handleEventOperation(callable $operation, string $successMessage)
    {
        try {
            $operation();
            return redirect()->back()->with(['status' => 'success', 'message' => $successMessage]);
        } catch (\Exception $e) {
            return redirect()->back()->with(['status' => 'error', 'message' => 'حدث خطأ أثناء تنفيذ العملية: ' . $e->getMessage()]);
        }
    }
    // private function Notificaton($id, $message)
    // {
    //     $user = User::find($id);
    //     $user->notify(new NotificationClient($user, $message));
    // }
    // public function handleExpiredCoupons()
    // {
    //     $now = Carbon::now();
    //     $expiredCoupons = Coupon::where('date_expire', '<', $now)->get();
    //     foreach ($expiredCoupons as $coupon) {
    //         $coupon->update(['status' => 'Expired']); // Assuming status is an integer or boolean
    //     }
    // }
    // public function handleEndCoupons()
    // {
    //     $expiredCoupons = Coupon::where('number_total', 0)->whereNull('date_expire')->get();
    //     foreach ($expiredCoupons as $coupon) {
    //         $coupon->update(['status' => 'Used']);
    //     }
    // }
    // public function readAllNotification()
    // {
    //     $notifications = auth()->user()->unreadNotifications;
    //     if ($notifications) {
    //         $notifications->markAsRead();
    //     }
    // }
    // public function readOneNotification($id)
    // {
    //     $notification = auth()->user()->unreadNotifications->find($id);
    //     if ($notification) {
    //         $notification->markAsRead();
    //     }

    //     return redirect()->back()->with('message', 'Notification marked as read');
    // }

    private function validateRole($type = null, $request)
    {
        if ($type) {
            $validator = Validator::make($request->all(), [
                'name' => 'required|string|max:255',
                'permissions' => 'array'
            ]);
        } elseif (!$type) {
            $validator = Validator::make($request->all(), [
                'permissions' => 'array'
            ]);
        }


        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
    }
}