<?php

namespace App\Traits;

trait CrudTraitApi
{
    private function handleEventOperation(callable $operation, string $successMessage, $data = null)
    {
        try {
            $result = $operation();
            return response()->json([
                'status' => 'success',
                'message' => $successMessage,
                'data' => $result ?? $data
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'حدث خطأ أثناء تنفيذ العملية: ' . $e->getMessage()
            ], 500);
        }
    }
    function generateRandomCode()
    {
        $letters = substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 5);
        $numbers = substr(str_shuffle('0123456789'), 0, 6);
        return $letters . $numbers;
    }

}