<?php

namespace App\Traits;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Traits\normalizeImageUrl;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

trait DataApi
{
    use normalizeImageUrl;
    private function dataUser($user)
    {
        return [
            'id' => (int) $user->id,
            'name' => $user->name,
            'email' => $user->email,
            'phone' => $user->phone,
            'nationality' => $user->nationality ? $user->nationality->name : null,
            'sex' => $user->sex,
            'isVerified' => $user->registration_confirmed ? true : false,
            'picture' => $user->image ? $this->normalizeImageUrl($user->image->url) : null,
        ];
    }
    private function dataUserAll($user)
    {
        return [
            'id' => (int) $user->id,
            'name' => $user->name,
            'email' => $user->email,
            'phone' => $user->phone,
            'key_phone' => $user->key_phone,
            'balance' => (int) $user->balance,
            'nationality' => $user->nationality ? $user->nationality->name : null,
            'sex' => $user->sex,
            'type' => $user->type,
            'otp' => $user->otp,
            'isVerified' => $user->registration_confirmed ? true : false,
            'categories_favourite' => $user->categories->map(function ($category) {
                return [
                    'name' => $category->name,
                    'id' => $category->id,
                    'image' => $this->normalizeImageUrl($category->image),
                    'logo' => $this->normalizeImageUrl($category->logo) // Adjust according to your attribute
                ];
            })->toArray() ?? [],
            'picture' => $user->image ? $this->normalizeImageUrl($user->image->url) : null,
        ];
    }
    private function dataCategory($categoty, $locale)
    {
        return [
            'id' => (int) $categoty->id,
            'name' => $categoty->getTranslation('name', $locale),
            'picture' => $this->normalizeImageUrl($categoty->image),
            'logo' => $this->normalizeImageUrl($categoty->logo)
        ];
    }

    /**
     * Summary of dataproduct
     * @param mixed $product
     * @param mixed $locale
     * @return array
     */
    private function dataproduct($product, $locale)
    {
        return [
            'id' => (int) $product->id,
            'Name' => $product->getTranslation('Name', $locale),
            'details' => $product->getTranslation('details', $locale),
            'name_title' => $product->getTranslation('name_title', $locale),
            'alt_title' => $product->getTranslation('alt_title', $locale),
            'price' => $product->Price,
            'old_price' => $product->old_price,
            'image' => asset($product->image),
            'meta_words' => $product->meta_words,
            'meta_description' => $product->meta_description,
            'serail_no' => $product->serail_no,
            'galleryImages' => $this->getGalleryImages($product),
        ];

    }
    private function getGalleryImages($product)
    {
        if (is_array($product->galleryImages)) {
            return array_map(function ($image) {
                return asset($image);
            }, $product->galleryImages);
        }
        return [];
    }
    private function dataproductShort($product, $locale)
    {
        return [
            'id' => (int) $product->id,
            'name' => $product->getTranslation('Name', $locale),
            'details' => $product->getTranslation('details', $locale),
            'price' => (int) $product->Price,
            'old_price' => (int) $product->old_price,
            'image' => $product->image ? asset($product->image) : null,
        ];

    }
    private function datareviewsproduct($product, $locale, $reviews)
    {
        $reviewsCollection = $reviews instanceof \Illuminate\Pagination\LengthAwarePaginator
            ? $reviews->getCollection()
            : $reviews;

        return [
            'reviews' => $reviewsCollection->map(function ($review) use ($locale) {
                $data = [];

                // أضف الحقول فقط إذا كانت موجودة وليست null
                if (isset($review->id)) {
                    $data['id'] = $review->id;
                }
                if (isset($review->reviewer_name)) {
                    $data['reviewer_name'] = $review->reviewer_name;
                }
                if (isset($review->comment)) {
                    $data['comment'] = $review->comment;
                }
                if (isset($review->rating)) {
                    $data['rating'] = (int) $review->rating;
                }
                if (isset($review->created_at)) {
                    $data['date'] = $review->created_at;
                }
                return $data;
            })->filter()
        ];
    }

    private function dataSlider($slider, $locale)
    {
        return [
            'id' => $slider->id,
            'image' => asset($slider->getTranslation('ImageURL', $locale)),
            'Position' => $slider->position->Name,
        ];
    }
    /**
     * Summary of dataPartner
     * @param mixed $slider
     * @param mixed $locale
     * @return array
     */
    private function dataPartner($slider, $locale)
    {
        return [
            'id' => $slider->id,
            'image' => asset('storage/' . $slider->LogoURL),
            'description' => $slider->Description,
            'name' => $slider->Name,
        ];
    }
    /**
     * Summary of uploadImage
     * @param \Illuminate\Http\Request $request
     * @param mixed $inputName
     * @param mixed $storagePath
     * @return bool|string|null
     */
    private function dataOurStory($slider, $locale): array
    {
        return [
            'id' => (int) $slider->id,
            'about_us_long' => $slider->getTranslation('about_us_long', $locale),
            'image' => $slider->image_url ? asset('storage/' . $slider->image_url) : null,
            'about_us_short' => $slider->getTranslation('about_us_short', $locale)
        ];
    }
    private function dataReviews($review, $locale): array
    {
        return [
            'id' => (int) $review->id,
            'name' => $review->name,
            'rate' => $review->rate,
            'image' => $review->image ? url(Storage::url($review->image)) : null,
            'review' => $review->getTranslation('review', $locale)
        ];
    }
    private function datafaq($faq, $locale)
    {
        return [
            'id' => (int) $faq->id,
            'question' => $faq->getTranslation('Question', $locale),
            'answer' => $faq->getTranslation('Answer', $locale)
        ];
    }
    private function dataBlog($blog, $lang)
    {
        return [
            'id' => (int) $blog->id,
            'title' => $blog->getTranslation('Title', $lang),
        ];
    }
    // private function dataBlogDeep($blog, $lang)
    // {
    //     return [
    //         'id' => (int) $blog->id,
    //         'title' => $blog->getTranslation('Title', $lang),
    //         'content' => $blog->getTranslation('Content', $lang),
    //         'related_Blog' => $blog->relatedBlogs->map(function ($item, $lang) {
    //             return [
    //                 'id' => (int) $item->id,
    //                 'title' => $item->getTranslation('Title', $lang),
    //                 'content' => $item->getTranslation('Content', $lang),
    //                 'image' => asset('storage/' . $item->image),

    //             ];
    //         }),
    //     ];
    // }

    private function dataBlogDeep($blog, $lang)
    {
        return [
            'id' => (int) $blog->id,
            'title' => $blog->getTranslation('Title', $lang),
            'content' => $blog->getTranslation('Content', $lang),
            'related_Blog' => $blog->relatedBlogs->map(function ($item) use ($lang) {
                return [
                    'id' => (int) $item->id,
                    'title' => $item->getTranslation('Title', $lang),
                    'content' => $item->getTranslation('Content', $lang),
                    'image' => asset('storage/' . $item->image),
                ];
            }),
        ];
    }
    private function dataAboutUs($aboutus)
    {
        return [
            'id' => (int) $aboutus->id,
            'meta_keywords' => $aboutus->meta_keywords,
            'meta_description' => $aboutus->meta_description,
            'facebook_link' => $aboutus->facebook_link,
            'twitter_link' => $aboutus->twitter_link,
            'instagram_link' => $aboutus->instagram_link,
            'youtube_link' => $aboutus->youtube_link,
            'tiktok_link' => $aboutus->tiktok_link,
            'site_name' => $aboutus->site_name,
            'phone_number' => $aboutus->phone_number,
            'address' => $aboutus->address,
            'site_logo' => asset(Storage::url($aboutus->site_logo)),
            'homepage_image' => asset(Storage::url($aboutus->homepage_image)),
            'location' => $aboutus->location,
        ];
    }

    private function dataCartItem($items, $locale)
    {
        return [
            'id' => (int) $items->id,
            'name' => $items->getTranslation('Name', $locale),
            'details' => $items->getTranslation('details', $locale),
            'price' => (int) $items->Price,
            'old_price' => (int) $items->old_price,
            'image' => $items->image ? asset($items->image) : null,

        ];
    }

}