<?php

namespace App\Traits;

use Illuminate\Http\Request;
use App\Models\dashboard\Product;
use App\Models\dashboard\SiteStatistic;

trait IpTrait
{

    public function ipAddress($page_views = null)
    {
        $ipAddress = request()->ip();
        $page = request()->path();
        $statistic = SiteStatistic::where('ip', $ipAddress)->where('page_views', $page)->first();

        if ($statistic) {
            $statistic->increment('total_visitors');
        } else {
            SiteStatistic::create([
                'total_visitors' => 1,
                'page_views' => $page,
                'ip' => $ipAddress,

            ]);
        }


    }

}