<?php

namespace App\Traits;

use Illuminate\Http\Request;
use App\Models\dashboard\Product;
use Illuminate\Support\Facades\Auth;

trait ProductTrait
{

    // Validate request inputs
    private function validateProduct(Request $request)
    {
        // Validate incoming data
        $validated = $request->validate([
            'name_ar' => 'required|string',
            'name_en' => 'required|string',
            'short_details_ar' => 'required|string',
            'short_details_en' => 'required|string',
            'details_ar' => 'required|string',
            'details_en' => 'required|string',
            'sizes_measures_ar' => 'required|string',
            'sizes_measures_en' => 'required|string',
            'delivery_restore_ar' => 'required|string',
            'delivery_restore_en' => 'required|string',
            'serail_no' => 'required|string|unique:products,code',
            'old_price' => 'required|numeric',
            'current_price' => 'required|numeric',
            'quantity' => 'required|numeric',
            'CategoryID' => 'required|exists:categories,id',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'images' => 'nullable|array',
            'images.*' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

    }

    // // Handle main image upload
    // private function handleMainImage(Request $request)
    // {
    //     if ($request->hasFile('image')) {
    //         dd(1);
    //         return $request->file('image')->store('product_images', 'public');

    //     }
    //     return null;
    // }

    // // Handle gallery images upload
    // private function handleGalleryImages(Request $request)
    // {
    //     $galleryImages = [];
    //     if ($request->hasFile('images')) {
    //         foreach ($request->file('images') as $image) {
    //             $galleryImages[] = $this->uploadFile('product_gallery', $image);
    //         }
    //     }
    //     return $galleryImages;
    // }
    private function handleMainImage(Request $request)
    {
        if ($request->hasFile('image')) {
            return $this->uploadFile('product_images', $request->file('image'));
        }
        return null;
    }

    // Handle gallery images upload
    private function handleGalleryImages(Request $request)
    {
        $galleryImages = [];
        if ($request->hasFile('images')) {
            foreach ($request->file('images') as $image) {
                $galleryImages[] = $this->uploadFile('product_gallery', $image);
            }
        }
        return $galleryImages;
    }
    private function createProduct(Request $request, $mainImage, array $galleryImages)
    {
        Product::create([
            'name' => $this->prepareJsonField($request->name_ar, $request->name_en),
            'image' => $mainImage,
            'description' => $this->prepareJsonField($request->details_ar, $request->details_en),
            'old_price' => $request->old_price,
            'new_price' => $request->current_price,
            'short_description' => $this->prepareJsonField($request->short_details_ar, $request->short_details_en),
            'long_description' => $this->prepareJsonField($request->long_description_ar, $request->long_description_en),
            'delivery_restore' => $this->prepareJsonField($request->delivery_restore_ar, $request->delivery_restore_en),
            'sizes_measures' => $this->prepareJsonField($request->sizes_measures_ar, $request->sizes_measures_en),
            'code' => $request->serail_no,
            'status_id' => $request->status_id ?: 1,
            'status_active_id' => $request->status_active_id ?: 1,
            'created_at' => now(),
            'updated_at' => now(),
            'category_id' => $request->CategoryID,
            'store_id' => Auth::id(),
            'num_stock' => $request->quantity ?: 1,
        ]);
    }


    // Helper to format JSON fields
    private function prepareJsonField($valueAr, $valueEn)
    {
        return ['ar' => $valueAr, 'en' => $valueEn];
    }

}