<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVendorRepairIssueTable extends Migration
{
    public function up()
    {
        Schema::create('vendor_repair_issue', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vendor_id')->constrained()->onDelete('cascade');
            $table->foreignId('repair_issue_id')->constrained()->onDelete('cascade');
            $table->timestamps();

            $table->unique(['vendor_id', 'repair_issue_id']);
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_general_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('vendor_repair_issue');
    }
}