<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVendorInspectionTable extends Migration
{
    public function up()
    {
        Schema::create('vendor_inspection', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vendor_id')->constrained()->onDelete('cascade');
            $table->foreignId('inspection_id')->constrained()->onDelete('cascade');
            $table->timestamps();

            $table->unique(['vendor_id', 'inspection_id']);
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_general_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('vendor_inspection');
    }
}