<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       
        Schema::create('spare_part_offers', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('custom_part_request_id'); // Link to order
            $table->unsignedBigInteger('vendor_id');              // Vendor making offer

            $table->enum('status', ['pending', 'accepted', 'rejected'])->default('pending');
            $table->decimal('price', 10, 2)->nullable();
            $table->string('warranty_period')->nullable();
            $table->timestamps();

            $table->foreign('custom_part_request_id')->references('id')->on('custom_part_requests')->onDelete('cascade');
            $table->foreign('vendor_id')->references('id')->on('vendors')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_offers');
    }
};
