<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('spare_part_offer_files', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('spare_part_offer_id');
            $table->string('file_path'); 
            $table->string('file_type')->nullable();

            $table->timestamps();

            $table->foreign('spare_part_offer_id')->references('id')->on('spare_part_offers')->onDelete('cascade');
        });
        Schema::create('product_images', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->cascadeOnDelete();
            $table->string('path'); // Stores the image path (e.g., 'products/images/xyz.jpg')
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('spare_part_offer_files');
    }
};
