<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       /*  Schema::create('products', function (Blueprint $table) {
            $table->id();
    
            $table->string('name');
            $table->decimal('price', 10, 2);
            $table->integer('stock')->default(0);
            $table->enum('condition', ['new', 'used-imported'])->default('new');
            
            // Offer/Discount fields
            $table->decimal('discount_percent', 5, 2)->nullable()->default(0);
            $table->date('offer_starts_at')->nullable();
            $table->date('offer_ends_at')->nullable();
            $table->unsignedBigInteger('vendor_id')->nullable();
            $table->unsignedBigInteger('category_id')->nullable();
            $table->unsignedBigInteger('car_category_id')->nullable();
             $table->unsignedBigInteger('brand_id')->nullable();
             $table->unsignedBigInteger('model_id')->nullable();

            $table->foreign('vendor_id')->references('id')->on('vendors')->onDelete('cascade');

            // For cars (optional)
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            $table->foreign('car_category_id')->references('id')->on('car_categories')->onDelete('cascade');
            $table->foreign('brand_id')->references('id')->on('brands')->onDelete('cascade');
            $table->foreign('model_id')->references('id')->on('models')->onDelete('cascade');
            $table->string('warranty_period')->nullable();
            $table->string('origin_country')->nullable();
    
           $table->timestamps();
        }); */
         Schema::create('product_images', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->cascadeOnDelete();
            $table->string('path'); // Stores the image path (e.g., 'products/images/xyz.jpg')
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
