<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wallets', function (Blueprint $table) {
            $table->id();
             $table->foreignId('vendor_id')->constrained()->onDelete('cascade');

            $table->unsignedInteger('spare_parts_count')->default(0);      // عدد قطع الغيار
            $table->decimal('spare_parts_total_price', 10, 2)->default(0); // إجمالي سعر قطع الغيار

            $table->unsignedInteger('product_count')->default(0);          // عدد المنتجات
            $table->decimal('product_total_price', 10, 2)->default(0);     // إجمالي سعر المنتجات

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallets');
    }
};
