<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('package_items', function (Blueprint $table) {
           $table->id();
            $table->foreignId('package_categorie_id')->constrained()->cascadeOnDelete();

            $table->foreignId('product_id')->nullable()->constrained()->nullOnDelete();

            $table->string('name')->nullable(); // لو مش مربوط بمنتج (زي "تنظيف المحرك")
            $table->decimal('price', 10, 2); // سعر العنصر (سواء منتج أو خدمة)
            $table->boolean('is_installation')->default(false); // true لو السعر يشمل تركيب

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('package_items');
    }
};
