<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('package_related_products', function (Blueprint $table) {
            $table->id();
    $table->foreignId('package_id')->constrained()->cascadeOnDelete();
    $table->foreignId('product_id')->constrained('spare_parts')->cascadeOnDelete();
    $table->timestamps();

    $table->unique(['package_id', 'product_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('package_related_products');
    }
};
