<div class="page-main-header">
    <div class="main-header-right row m-0">
        <div class="main-header-left">
            <div class="logo-wrapper"><a href="{{ route('admin.home') }}"><img class="img-fluid"
                        src="{{ asset('assets/images/logo/logo.png') }}" alt=""></a></div>
            <div class="dark-logo-wrapper"><a href="{{ route('admin.home') }}">Part Mart</a></div>
            <div class="toggle-sidebar"><i class="status_toggle middle" data-feather="align-center"
                    id="sidebar-toggle"></i></div>
        </div>
        <div class="left-menu-header col">
            <ul>
                <li></li>
            </ul>
        </div>
        <div class="nav-right col pull-right right-menu p-0 box-col-6">
            <ul class="nav-menus">
                <!-- Notification Icon with Dropdown -->
                <li class="onhover-dropdown">
                    <a href="#!" class="position-relative">
                        <i data-feather="bell"></i>
                        @php
                        $unreadNotifications = auth()->user()->notifications()->where('is_read', 0)->count();
                        @endphp
                        @if ($unreadNotifications > 0)
                        <span class="badge badge-pill badge-danger position-absolute top-0 start-100 translate-middle">
                            {{ $unreadNotifications > 9 ? '9+' : $unreadNotifications }}
                        </span>
                        @endif
                    </a>
                    <ul class="onhover-show-div notification-dropdown p-3" style="width: 300px;">
                        <li class="d-flex justify-content-between align-items-center">
                            <h6 style="font-family: 'Cairo', sans-serif;">الإشعارات</h6>
                            @if ($unreadNotifications > 0)
                            <span class="badge badge-primary">{{ $unreadNotifications }} جديد</span>
                            @endif
                        </li>
                        <hr>
                        @php
                        $notifications = auth()->user()->notifications()->latest()->take(5)->get();
                        @endphp
                        @forelse ($notifications as $notification)
                        <li class="d-flex align-items-start {{ $notification->is_read ? '' : 'bg-light' }} mb-2">
                            <i data-feather="bell" class="me-2"></i>
                            <div>
                                <h6 style="font-family: 'Cairo', sans-serif;">{{ $notification->title }}</h6>
                                <p class="text-muted" style="font-family: 'Cairo', sans-serif;">
                                    {{ Str::limit($notification->body, 50) }}
                                </p>
                                <small class="text-muted">{{ $notification->created_at->diffForHumans() }}</small>
                            </div>
                        </li>
                        @empty
                        <li style="font-family: 'Cairo', sans-serif;">لا توجد إشعارات</li>
                        @endforelse
                        <li class="text-center">
                            <a href="{{ route('admin.notifications.index') }}" class="btn btn-link text-primary"
                                style="font-family: 'Cairo', sans-serif;">رؤية المزيد</a>
                        </li>
                    </ul>
                </li>
                <!-- Existing Menu Items -->
                <li><a class="text-dark" href="#!" onclick="javascript:toggleFullScreen()"><i
                            data-feather="maximize"></i></a></li>
                <li>
                    <div class="mode"><i class="fa fa-moon-o"></i></div>
                </li>
                <li class="onhover-dropdown p-0">
                    <button class="btn btn-primary-light" type="button"><a href="{{ route('admin.logout') }}"><i
                                data-feather="log-out"></i> تسجيل خروج</a></button>
                </li>
            </ul>
        </div>
        <div class="d-lg-none mobile-toggle pull-right w-auto"><i data-feather="more-horizontal"></i></div>
    </div>
</div>