@extends('admin.pages.auth.layout')
@section('title')
تسحيل دخول
@endsection
@section('body')
<section>
    <div class="container-fluid p-0">
        <div class="row">
            <div class="col-12">
                <div class="login-card">
                    <form class="theme-form login-form" method="POST" action="{{ route('admin.login') }}">
                        <!-- Flash Error Message -->
                        @if (session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                        @endif
                        @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif
                        @csrf
                        <h4>تسجيل الدخول</h4>
                        <h6>مرحبًا بعودتك! قم بتسجيل الدخول إلى حسابك.</h6>
                        <div class="form-group">
                            <label>عنوان البريد الإلكتروني</label>
                            <div class="input-group"><span class="input-group-text"><i class="icon-email"></i></span>
                                <input class="form-control" type="email" name="email" required=""
                                    placeholder="Test@gmail.com" value="{{ old('email') }}">
                            </div>
                            @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label>كلمة المرور</label>
                            <div class="input-group"><span class="input-group-text"><i class="icon-lock"></i></span>
                                <input class="form-control" type="password" name="password" required=""
                                    placeholder="*********">
                                <div class="show-hide"><span class="show"> </span></div>
                            </div>
                            @error('password')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <button class="btn btn-primary btn-block" type="submit">تسجيل الدخول</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection