@extends('admin.layouts.master')

@section('title', 'تعديل سلايدر الموديل')

@section('css')
    @include('admin.layouts.css')
@endsection

@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif
    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <h3 style="font-family: 'Cairo', sans-serif;">تعديل سلايدر الموديل</h3>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">الرئيسية</a></li>
                <li class="breadcrumb-item active">سلايدر الموديل</li>
            </ol>
        </div>

        <form method="POST"  action="{{ route('admin.sliders.update', $slider->id) }}" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="card">
                <div class="card-body">

                    <!-- Arabic Title -->
                    <div class="form-group">
                        <label>العنوان بالعربية</label>
                        <input type="text" name="title[ar]" class="form-control"
                               value="{{ $slider->getTranslation('title','ar') }}" required>
                    </div>

                    <!-- English Title -->
                    <div class="form-group">
                        <label>العنوان بالإنجليزية</label>
                        <input type="text" name="title[en]" class="form-control"
                               value="{{ $slider->getTranslation('title','en')}}" required>
                    </div>

                    <!-- Model Select -->
                  

                    <!-- Order -->
                    <div class="form-group">
                        <label>الترتيب</label>
                        <input type="number" name="order" class="form-control" value="{{ $slider->order }}">
                    </div>

                    <!-- Is Active -->
                    <div class="form-group">
                        <label>الحالة</label>
                        <select name="is_active" class="form-control">
                            <option value="1" {{ $slider->is_active ? 'selected' : '' }}>مفعل</option>
                            <option value="0" {{ !$slider->is_active ? 'selected' : '' }}>غير مفعل</option>
                        </select>
                    </div>

                    <!-- Image Upload -->
                    <div class="form-group">
                        <label>الصورة</label>
                        <input type="file" name="image_url" class="form-control">
                        @if($slider->image_url)
                            <img src="{{ asset($slider->image_url) }}" width="120" class="mt-2">
                        @endif
                    </div>

                    <button type="submit" class="btn btn-primary">تحديث</button>

                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('js')
    @include('admin.layouts.js')
@endsection
