@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>
<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">الصــــــور المتحركــــة</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.home')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيـــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">الصــور المتحركـــــــة
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6">

                </div>
            </div>
        </div>
    </div>
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <!-- DOM / jQuery  Starts-->
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            <button type="button" class="btn-success btn-lg" data-bs-toggle="modal"
                                data-bs-target="#bannerModal" style="font-family: 'Cairo', sans-serif;">
                                أضافـــــــة صــورة جـديــدة
                            </button>

                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Image</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sliders as $slider)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>
                                            <img width="120" src="{{asset($slider->image_url)}}"
                                                alt="Slider Image">
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.sliders.edit', $slider->id) }}"
                                                class="btn btn-success">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.sliders.destroy', $slider->id) }}"
                                                method="POST" style="display: inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger">
                                                    <i class="fa fa-remove"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>


                    </div>
                </div>
            </div>
            <!-- DOM / jQuery  Ends-->
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>
<!-- Modal -->
<div class="modal fade" id="bannerModal" tabindex="-1" aria-labelledby="bannerModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="bannerModalLabel" style="font-family: 'Cairo', sans-serif;">أضـــــافة
                    صــــوره متحركـة</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="POST" action="{{ route('admin.sliders.store') }}" enctype="multipart/form-data">
                    @csrf
                    <!-- Image -->
                    <div class="mb-3">
                        <label>اختر صورة</label>
                        <input type="file" name="image" class="form-control" required>
                    </div>

                    <!-- Title Arabic -->
                    <div class="mb-3">
                        <label>العنوان بالعربية</label>
                        <input type="text" name="title_ar" class="form-control" required>
                    </div>

                    <!-- Title English -->
                    <div class="mb-3">
                        <label>العنوان بالإنجليزية</label>
                        <input type="text" name="title_en" class="form-control" required>
                    </div>

                    <!-- Vendor -->
                  <!-- Vendor select -->
                    <div class="mb-3">
                        <label>اختر البائع</label>
                        <select name="vendor_id" id="vendor-select" class="form-control" >
                            <option value="">-- اختر البائع --</option>
                            @foreach($vendors as $vendor)
                                <option value="{{ $vendor->id }}">{{ $vendor->name }}</option>
                            @endforeach
                        </select>
                    </div>

                  

                     <div class="mb-3">
                        <label>اختر العرض المتاح </label>
                        <select name="offer_id" id="vendor-select" class="form-control" style="background-color:rgb(12, 8, 20)">
                            <option value="">-- اختر العرض --</option>
                            @foreach($activeOffers as $activeOffer)
                                <option value="{{ $activeOffer->id }}">{{ $activeOffer->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <!-- Order -->
                    <div class="mb-3">
                        <label>الترتيب</label>
                        <input type="number" name="order" class="form-control" value="0">
                    </div>

                    <!-- Is Active -->
                    <div class="mb-3">
                        <label>الحالة</label>
                        <select name="is_active" class="form-control">
                            <option value="1">مفعل</option>
                            <option value="0">غير مفعل</option>
                        </select>
                    </div>

                    <!-- Submit -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="submit" class="btn btn-primary">حفظ</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
@include('admin.layouts.js')
@endsection