@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')
@endsection
@section('body')
<!-- Page Sidebar Ends-->
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>إعدادات الكوبونات</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}">لوحة التحكم</a></li>
                        <li class="breadcrumb-item">الإعدادات</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5>تحديث مقالة</h5>
                    </div>
                    <div class="card-body">
                        <form method="post" action="{{ route('blogs.update', ['blog'=>$item]) }}"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                <!-- Arabic Title -->
                                <div class="col-md-6">
                                    <label class="form-label">العنوان عربي</label>
                                    <input type="text" name="title_ar" class="form-control"
                                        value="{{ $item->getTranslation('Title', 'ar')}}" required>
                                </div>

                                <!-- English Title -->
                                <div class="col-md-6">
                                    <label class="form-label">العنوان انجليزي</label>
                                    <input type="text" name="title_en" class="form-control"
                                        value="{{ $item->getTranslation('Title', 'en') }}" required>
                                </div>

                                <!-- Arabic Short Content -->
                                <div class="col-md-6 mt-3">
                                    <label class="mr-sm-2">محتوي قصير بالعربية</label>
                                    <textarea id="editor1" name="content_ar" rows="5"
                                        class="form-control">{{ old('content_ar', $item->getTranslation('Content', 'ar')) }}</textarea>
                                </div>

                                <!-- English Short Content -->
                                <div class="col-md-6 mt-3">
                                    <label class="mr-sm-2">محتوي قصير بالإنجليزية</label>
                                    <textarea name="content_en" rows="5"
                                        class="form-control">{{ old('content_en', $item->getTranslation('Content', 'en')) }}</textarea>
                                </div>

                                <!-- Arabic Long Content -->
                                <div class="col-md-12 mt-3">
                                    <label class="mr-sm-2">المحتوى بالعربية</label>
                                    <textarea id="editor1" name="long_content_ar" rows="10"
                                        class="form-control">{{ old('long_content_ar', $item->getTranslation('long_content', 'ar')) }}</textarea>
                                </div>

                                <!-- English Long Content -->
                                <div class="col-md-12 mt-3">
                                    <label class="mr-sm-2">المحتوى بالإنجليزية</label>
                                    <textarea name="long_content_en" rows="10"
                                        class="form-control">{{ old('long_content_en', $item->getTranslation('long_content', 'en')) }}</textarea>
                                </div>

                                <!-- Blog Category Selection -->
                                <div class="mb-2 mt-3">
                                    <label class="col-form-label">اختار انتماء المدونه</label>
                                    <select class="js-example-basic-multiple col-sm-12 select2-hidden-accessible"
                                        name="id_blog">
                                        <option value="">اختر</option>
                                        @foreach ($items_fs as $items_f)
                                        <option value="{{ $items_f->id }}" {{ $items_f->id_blog == $items_f->id ?
                                            'selected' : ''
                                            }}>{{ $items_f->Title }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- External Image -->
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <label class="mr-sm-2">صوره خارجيه</label>
                                        <input type="file" name="image" class="form-control"
                                            style="border:solid 1px #555;">
                                        @if($item->image)
                                        <img src="{{ asset('storage/' . $item->image) }}" alt="Current Image"
                                            style="width: 100px; margin-top: 10px;">
                                        @endif
                                    </div>
                                </div>

                                <!-- Internal Image -->
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <label class="mr-sm-2">صوره داخليه</label>
                                        <input type="file" name="imageInside" class="form-control"
                                            style="border:solid 1px #555;">
                                        @if($item->imageInside)
                                        <img src="{{ asset('storage/' . $item->imageInside) }}"
                                            alt="Current Image Inside" style="width: 100px; margin-top: 10px;">
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <br>
                            <button class="btn btn-primary" type="submit">تحديث</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
@include('dashboard.layouts.js')


@endsection