@extends('admin.layouts.master')

@section('title')
    براندات السيارات
@endsection

@section('css')
    @include('admin.layouts.css')
@endsection

@section('body')
    {{-- Toastr --}}
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        @if(session('success'))
            toastr.success("{{ session('success') }}");
        @endif
        @if(session('error'))
            toastr.error("{{ session('error') }}");
        @endif
    </script>

    <div class="page-body">
        <div class="container-fluid">
            <div class="page-header">
                <div class="row">
                    <div class="col-sm-6">
                        <h3 style="font-family: 'Cairo', sans-serif;"> براندات السيارات</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ url('admin/dashboard') }}" style="font-family: 'Cairo', sans-serif;">
                                    الرئيسيــــــة /
                                </a>
                            </li>
                            <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;"> براندات السيارات </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-body">

                            {{-- زر إضافة --}}
                            <div class="mb-3">
                                <a href="{{ route('admin.carbrand.create') }}" class="btn btn-success btn-lg" style="font-family: 'Cairo', sans-serif;">
                                    أضافـــــــة براند جــديــد
                                </a>
                            </div>

                            {{-- زر الحذف الجماعي --}}
                            <form id="bulkDeleteForm" action="{{ route('admin.carbrand.bulk_delete') }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <button type="submit" id="bulkDeleteBtn" class="btn btn-danger mb-3" disabled>
                                    حذف المحددين
                                </button>
                            </form>

                            {{-- جدول البراندات --}}
                            <div class="table-responsive">
                                <table class="display datatables" id="dt-plugin-method">
                                    <thead>
                                        <tr>
                                            <th><input type="checkbox" id="selectAll"></th>
                                            <th>#</th>
                                            <th style="font-family: 'Cairo', sans-serif;">اســــم البراند</th>
                                            <th style="font-family: 'Cairo', sans-serif;"> الصورة الخاصة بالبراند</th>

                                            <th style="font-family: 'Cairo', sans-serif;">العمليـــــات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($brands as $i => $brand)
                                            <tr>
                                                <td>
                                                    <input type="checkbox" name="ids[]" value="{{ $brand->id }}" form="bulkDeleteForm" class="rowCheckbox">
                                                </td>
                                                <td>{{ $i + 1 }}</td>
                                                <td>{{ $brand->name['ar'] }}</td>
                                                 <td>
                                                    @if ($brand->image)
                                                    <img width="120" src="{{ asset('storage/' . $brand->image) }}"
                                                        alt="brand Image">
                                                    @else
                                                    <span>لا توجد صورة</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    {{-- Edit --}}
                                                    <button class="btn btn-success btn-sm" type="button" data-bs-toggle="modal" data-bs-target="#edit{{ $brand->id }}">
                                                        <i class="fa fa-edit"></i>
                                                    </button>

                                                    {{-- Delete --}}
                                                    <button class="btn btn-danger btn-sm" type="button" data-bs-toggle="modal" data-bs-target="#delete{{ $brand->id }}">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </td>
                                            </tr>

                                            {{-- Edit Modal --}}
                                            <div class="modal fade" id="edit{{ $brand->id }}" tabindex="-1" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" style="font-family: 'Cairo', sans-serif;">تعديل البراند</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <form action="{{ route('admin.carbrand.update', $brand->id) }}" method="POST" enctype="multipart/form-data">
                                                                @csrf
                                                                @method('PATCH')
                                                                <div class="mb-3">
                                                                    <label>اسم البراند (العربية)</label>
                                                                    <input class="form-control" type="text" name="name_ar" value="{{ old('name_ar', $brand->name['ar']) }}" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label>اسم البراند (الإنجليزية)</label>
                                                                    <input class="form-control" type="text" name="name_en" value="{{ old('name_en', $brand->name['en']) }}" required>
                                                                </div>


                                                                 <div class="mb-3">
                                                                    <label
                                                                        style="font-family: 'Cairo', sans-serif;">الصورة</label>
                                                                    <input class="form-control" type="file" name="image"
                                                                        accept="image">
                                                                    @if ($brand->image)
                                                                    <small>الصورة الحالية: <img
                                                                            src="{{ asset('storage/' . $brand->image) }}"
                                                                            width="100" alt="Current Image"></small>
                                                                    @endif
                                                                    @error('image')
                                                                    <span class="text-danger">{{ $message }}</span>
                                                                    @enderror
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label
                                                                        style="font-family: 'Cairo', sans-serif;">الحالة</label>
                                                                    <select name="is_active" class="form-control" required>
                                                                        <option value="1" {{ old('is_active', $brand->
                                                                            active) ? 'selected' : '' }}>
                                                                            مفعل
                                                                        </option>
                                                                        <option value="0" {{ old('is_active', $brand->
                                                                            active) ? '' : 'selected' }}>
                                                                            غير مفعل
                                                                        </option>
                                                                    </select>
                                                                    @error('is_active')
                                                                    <span class="text-danger">{{ $message }}</span>
                                                                    @enderror
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">إغلاق</button>
                                                                    <button class="btn btn-primary" type="submit">حفظ</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            {{-- Delete Modal --}}
                                            <div class="modal fade" id="delete{{ $brand->id }}" tabindex="-1" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" style="font-family: 'Cairo', sans-serif;">تأكيد الحذف</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد أنك تريد حذف "{{ $brand->name['ar'] }}" ؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('admin.carbrand.destroy', $brand->id) }}" method="POST" style="display:inline;">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button class="btn btn-danger" type="submit">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Script for select all --}}
    <script>
        $('#selectAll').on('click', function() {
            $('.rowCheckbox').prop('checked', this.checked);
            toggleBulkDeleteBtn();
        });

        $('.rowCheckbox').on('change', function() {
            toggleBulkDeleteBtn();
        });

        function toggleBulkDeleteBtn() {
            let anyChecked = $('.rowCheckbox:checked').length > 0;
            $('#bulkDeleteBtn').prop('disabled', !anyChecked);
        }
    </script>
@endsection

@section('js')
    @include('admin.layouts.js')
@endsection
