@extends('admin.layouts.master')

@section('title')
إضافة سيارة جديدة
@endsection

@section('css')
@include('admin.layouts.css')
@endsection

@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.car_sales.index') }}">السيارات المعروضة</a></li>
                        <li class="breadcrumb-item">إضافة سيارة جديدة</li>
                    </ol>
                </div>
            </div>
        </div>

        @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5>إضافة سيارة جديدة</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.car_sales.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-md-6">
                                    <label>اسم العميل</label>
                                    <select name="user_id" id="user_id" class="form-control" required style="background-color: red">
                                        <option value="">اختر العميل</option>
                                        @foreach($users as $user)
                                        <option style="background-color: red" value="{{ $user->id }}">{{ $user->full_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>موديل السيارة</label>
                                    <select name="model_id" class="form-control" required>
                                        <option value="">اختر الموديل</option>
                                        @foreach($models as $model)
                                        <option value="{{ $model->id }}">{{ $model->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>السعر</label>
                                    <input type="number" name="price" class="form-control" required>
                                </div>

                                <div class="col-md-6">
                                    <label>الكيلومترات</label>
                                    <input type="number" name="mileage" class="form-control" required>
                                </div>

                                <div class="col-md-6">
                                    <label>نوع ناقل الحركة</label>
                                    <select name="transmission_type" class="form-control" required>
                                        <option value="">اختر</option>
                                        <option value="1">عادي</option>
                                        <option value="0">أوتوماتيك</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>السنة</label>
                                    <input type="number" name="production_year" class="form-control" required>
                                </div>

                                <div class="col-md-6">
                                    <label>رقم الهاتف</label>
                                    <input type="text" name="phone_number" class="form-control" required>
                                </div>

                                <div class="col-md-6">
                                    <label>هل واتساب؟</label>
                                    <select name="is_whatsapp" class="form-control" required>
                                        <option value="0">لا</option>
                                        <option value="1">نعم</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>المدينة</label>
                                    <select name="city_id" class="form-control" required>
                                        <option value="">اختر المدينة</option>
                                        @foreach($cities as $city)
                                        <option value="{{ $city->id }}">{{ $city->name['ar']}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>الشكل</label>
                                    <select name="style_id" class="form-control" required>
                                        <option value="">اختر الشكل</option>
                                        @foreach($styles as $style)
                                        <option value="{{ $style->id }}">{{ $style->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>هل يوجد تقسيط؟</label>
                                    <select name="installment_available" class="form-control" required>
                                        <option value="0">لا</option>
                                        <option value="1">نعم</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>هل قابل للتفاوض؟</label>
                                    <select name="negotiability" class="form-control" required>
                                        <option value="0">لا</option>
                                        <option value="1">نعم</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>الصورة</label>
                                    <input type="file" name="image" class="form-control" required>
                                </div>

                                <div class="col-md-12">
                                    <label>الوصف</label>
                                    <textarea name="description" class="form-control" rows="3" required></textarea>
                                </div>

                                <div class="col-md-12">
                                    <label>ملاحظات</label>
                                    <textarea name="notes" class="form-control" rows="2"></textarea>
                                </div>

                                <div class="col-md-12 mt-3">
                                    <label>تفعيل</label>
                                    <select name="is_active" class="form-control">
                                        <option value="1">نعم</option>
                                        <option value="0">لا</option>
                                    </select>
                                </div>

                                <div class="col-md-12 mt-4">
                                    <button type="submit" class="btn btn-primary">حفظ البيانات</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('js')
@include('admin.layouts.js')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('#user_id').select2({
            placeholder: "اختر العميل",
            allowClear: true
        });
    });
</script>
@endsection
