@extends('admin.layouts.master')

@section('title', 'إدارة سوق السيارات')

@section('css')
@include('admin.layouts.css')
@endsection

@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>ســوق الســيارات</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item active"> ســوق الســيارات</li>
                    </ol>
                </div>
                <div class="col-sm-6 text-end">
                    <a href="{{ route('admin.car_sales.create') }}" class="btn btn-success btn-lg">إضافة سيارة جديدة</a>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="card p-3">
            <div class="table-responsive">
                <table dir="rtl" class="display datatables" id="dt-plugin-method">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>الموديل</th>
                            <th>الطراز</th>
                            <th>السنة</th>
                            <th>المدينة</th>
                            <th>السعر</th>
                            <th>المسافة المقطوعة</th>
                            <th>الوصف</th>
                            <th>رقم الهاتف</th>
                            <th>واتساب</th>
                            <th>تقسيط</th>
                            <th>قابل للتفاوض</th>
                            <th>الصورة</th>
                            <th>ملاحظات</th>
                            <th>الحالة</th>
                            <th>تاريخ الإضافة</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($cars as $car)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ optional($car->model)->name ?? 'غير متوفر' }}</td>
                            <td>{{ optional($car->style)->name ?? 'غير متوفر' }}</td>
                            <td>{{ $car->production_year ?? '-' }}</td>
                            <td>{{ $car->city?->name['ar'] ?? 'غير محدد' }}</td>                            <td>{{ number_format((float)$car->price, 2) }} ج.م</td>
                            <td>{{ $car->mileage ? number_format($car->mileage) . ' كم' : '-' }}</td>
                            <td>{{ Str::limit(strip_tags($car->description), 50) ?? '-' }}</td>
                            <td>{{ $car->phone_number ?? '-' }}</td>
                            <td>{!! $car->is_whatsapp ? '<span class="badge bg-success">نعم</span>' : '<span class="badge bg-danger">لا</span>' !!}</td>
                            <td>{!! $car->installment_available ? '<span class="badge bg-success">نعم</span>' : '<span class="badge bg-danger">لا</span>' !!}</td>
                            <td>{!! $car->negotiability ? '<span class="badge bg-success">نعم</span>' : '<span class="badge bg-danger">لا</span>' !!}</td>
                            <td>
                                @if($car->image)
                                    <img src="{{ asset('storage/' . $car->image) }}" width="70">
                                @else
                                    <span>لا يوجد</span>
                                @endif
                            </td>
                            <td>{{ $car->notes ?? '-' }}</td>
                            <td>{!! $car->is_active == 1 ? '<span class="badge bg-success">مفعل</span>' : '<span class="badge bg-danger">غير مفعل</span>' !!}</td>
                            <td>{{ $car->created_at ? $car->created_at->format('Y-m-d') : '-' }}</td>
                            <td>
                               <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $car->id }}">
                                    <i class="fa fa-trash"></i> حذف
                                </button>
                                <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#updateStatusModal{{ $car->id }}">
                                    <i class="fa fa-bullhorn"></i> تحديث الحالة
                                </button>
                            </td>
                        </tr>
                         <!-- Delete Modal -->
                         <div class="modal fade" id="deleteModal{{ $car->id }}" tabindex="-1"
                                    aria-labelledby="deleteModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="deleteModalLabel">حذف السيارة</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="إغلاق"></button>
                                            </div>
                                            <div class="modal-body">
                                                هل أنت متأكد أنك تريد حذف هذه السيارة ؟
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">إلغاء</button>
                                                <form action="{{ route('admin.car_sales.destroy', $car->id) }}"
                                                    method="post" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                        
                       <!-- Update Status Modal -->
                        <div class="modal fade" id="updateStatusModal{{ $car->id }}" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content bg-light shadow-lg"> <!-- خليت الخلفية صلبة -->
                                    <form action="{{ route('admin.car_sales.update', $car->id) }}" method="POST">
                                        @csrf
                                        @method('PUT')

                                        <div class="modal-header bg-primary text-white">
                                            <h5 class="modal-title">
                                                <i class="fas fa-sync-alt me-2"></i> تحديث حالة السيارة
                                            </h5>
                                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                                        </div>

                                        <div class="modal-body">
                                            <div class="mb-3">
                                                <label for="statusSelect{{ $car->id }}" class="form-label fw-bold">اختر الحالة:</label>
                                                <select id="statusSelect{{ $car->id }}" name="status" class="form-select" required>
                                                    <option value="" disabled>-- اختر الحالة --</option>
                                                    <option value="0" {{ $car->is_active == 0 ? 'selected' : '' }}>معلق</option>
                                                    <option value="1" {{ $car->is_active == 1? 'selected' : '' }}>موافق عليه</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                               إلغاء
                                            </button>
                                            <button type="submit" class="btn btn-success">
                                                 تحديث
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
@include('admin.layouts.js')
@endsection