@extends('admin.layouts.master')
@section('title')
 موديـــل السيــــارات
@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> موديـــل السيــــارات</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;"> موديـــل السيــــارات
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            <a href="{{ route('admin.carmodel.create') }}" class="btn btn-success btn-lg"
                                style="font-family: 'Cairo', sans-serif;">
                                أضافـــــــة موديـــل جــديــد
                            </a>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">اســــم الموديل</th>
                                         <th style="font-family: 'Cairo', sans-serif;"> اســــم البراند النتمي لية</th>
                                        <th style="font-family: 'Cairo', sans-serif;">    السنة  </th>

                                        <th style="font-family: 'Cairo', sans-serif;">العمليـــــات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($models as $model)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{ $i }}</td>
                                        <td>{{ $model->getTranslation('name', 'ar') }}</td>
                                        <td>
                                           {{ $model->brand?->name['ar'] }}
                                        </td>
                                         <td>
                                           {{ $model->year}}
                                        </td>
                                        
                                        <td>
                                            <button class="btn btn-success btn-sm" type="button" data-bs-toggle="modal"
                                                data-bs-target="#edit{{ $model->id }}"><i
                                                    class="fa fa-edit"></i></button>
                                            <button class="btn btn-danger btn-sm" type="button" data-bs-toggle="modal"
                                                data-bs-target="#delete{{ $model->id }}"><i
                                                    class="fa fa-trash"></i></button>
                                        </td>
                                    </tr>

                                    <!-- Edit Modal -->
                                    <div class="modal fade" id="edit{{ $model->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="editmodelLabel{{ $model->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editmodelLabel{{ $model->id }}"
                                                        style="font-family: 'Cairo', sans-serif;">تعديل القســم</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                @php
                                                        $years = explode('_', $model->year);
                                                        $year_from = $years[0] ?? '';
                                                        $year_to = $years[1] ?? '';
                                                    @endphp
                                                                                                    <form action="{{ route('admin.carmodel.update', $model->id) }}"
                                                        method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        @method('PATCH')
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">اسم القسم
                                                                (العربية)</label>
                                                            <input class="form-control" type="text" name="name_ar"
                                                                value="{{ old('name_ar', $model->getTranslation('name', 'ar')) }}"
                                                                required>
                                                            @error('name_ar')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">اسم القسم
                                                                (الإنجليزية)</label>
                                                            <input class="form-control" type="text" name="name_en"
                                                                value="{{ old('name_en', $model->getTranslation('name', 'en')) }}"
                                                                required>
                                                            @error('name_en')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                      
                                                      {{--   <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">
                                                                قسم السيارة الخاص </label>
                                                            <select name="parent_id" class="form-control">
                                                                <option value="">لا يوجد قسم رئيسي</option>
                                                                @foreach ($carcategories as $parent)
                                                                @if ($parent->id !== $model->id)
                                                                <option value="{{ $parent->id }}" {{ old('parent_id',
                                                                    $model->parent_id) == $parent->id ? 'selected' :
                                                                    '' }}>
                                                                    {{ $parent->name['ar'] }}
                                                                </option>
                                                                @endif
                                                                @endforeach
                                                            </select>
                                                            @error('parent_id')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div> --}}
                                                     {{--     <div class="mb-3">
                                                                <label style="font-family: 'Cairo', sans-serif;"> 
                                                                    سنة الموديل</label>
                                                            <select name="model_year">
                                                                @for ($year = date('Y'); $year >= 1900; $year--)
                                                                    <option value="{{ $year }}">{{ $year }}</option>
                                                                @endfor
                                                            </select>
                                                       </div> --}}
                                              <div class="row g-3">
                                            <!-- From Year -->
                                            <div class="mb-3 col-md-6">
                                                <label style="font-family: 'Cairo', sans-serif;">سنة الموديل من</label>
                                                <select name="year_from" class="form-control">
                                                    @for ($year = date('Y'); $year >= 1900; $year--)
                                                        <option value="{{ $year }}" {{ $year_from == $year ? 'selected' : '' }}>
                                                            {{ $year }}
                                                        </option>
                                                    @endfor
                                                </select>
                                            </div>

                                            <!-- To Year -->
                                            <div class="mb-3 col-md-6">
                                                <label style="font-family: 'Cairo', sans-serif;">سنة الموديل إلى</label>
                                                <select name="year_to" class="form-control">
                                                    @for ($year = date('Y'); $year >= 1900; $year--)
                                                        <option value="{{ $year }}" {{ $year_to == $year ? 'selected' : '' }}>
                                                            {{ $year }}
                                                        </option>
                                                    @endfor
                                                </select>
                                            </div>
                                        </div>
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">
                                                                البراند  الخاص </label>
                                                            <select name="brand_id" class="form-control">
                                                                <option value="">لا يوجد قسم رئيسي</option>
                                                                @foreach ($brands as $brand)
                                                                @if ($brand->id !== $model->id)
                                                                <option value="{{ $brand->id }}" {{ old('parent_id',
                                                                    $model->brand_id) == $brand->id ? 'selected' :
                                                                    '' }}>
                                                                    {{ $brand->name[ 'ar'] }}
                                                                </option>
                                                                @endif
                                                                @endforeach
                                                            </select>
                                                            @error('parent_id')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                        <div class="mb-3">
                                                            <label
                                                                style="font-family: 'Cairo', sans-serif;">الحالة</label>
                                                            <select name="is_active" class="form-control" required>
                                                                <option value="1" {{ old('is_active', $model->
                                                                    active) ? 'selected' : '' }}>
                                                                    مفعل
                                                                </option>
                                                                <option value="0" {{ old('is_active', $model->
                                                                    active) ? '' : 'selected' }}>
                                                                    غير مفعل
                                                                </option>
                                                            </select>
                                                            @error('is_active')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                       
                                                        <div class="modal-footer">
                                                            <button class="btn btn-secondary" type="button"
                                                                data-bs-dismiss="modal">إغلاق</button>
                                                            <button class="btn btn-primary" type="submit">حفظ</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="delete{{ $model->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="deletemodelLabel{{ $model->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deletemodelLabel{{ $model->id }}"
                                                        style="font-family: 'Cairo', sans-serif;">تأكيد الحذف</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    هل أنت متأكد أنك تريد حذف قسم "{{ $model->getTranslation('name',
                                                    'ar') }}"؟ هذا الإجراء لا يمكن التراجع عنه.
                                                </div>
                                                <div class="modal-footer">
                                                    <button class="btn btn-secondary" type="button"
                                                        data-bs-dismiss="modal">إلغاء</button>
                                                    <form
                                                        action="{{ route('admin.carmodel.destroy', $model->id) }}"
                                                        method="POST" style="display: inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button class="btn btn-danger" type="submit">حذف</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')
@endsection