@extends('admin.layouts.master')
@section('title')
الأقسام الرئيسية
@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">الأقســـــــام الرئيسيـــــة</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">الأقســام الرئيسيـــــــة
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            <a href="{{ route('admin.categories.create') }}" class="btn btn-success btn-lg"
                                style="font-family: 'Cairo', sans-serif;">
                                أضافـــــــة قســم جــديــد
                            </a>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">اســــم القســم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الصـــورة الخاصة بالقسم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الحالة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليـــــات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($categories as $category)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{ $i }}</td>
                                        <td>{{ $category->getTranslation('name', 'ar') }}</td>
                                        <td>
                                            @if ($category->image)
                                            <img width="120" src="{{ asset('storage/' . $category->image) }}"
                                                alt="Category Image">
                                            @else
                                            <span>لا توجد صورة</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span
                                                class="badge {{ $category->is_active ? 'badge-success' : 'badge-danger' }}">
                                                {{ $category->is_active ? 'مفعل' : 'غير مفعل' }}
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-success btn-sm" type="button" data-bs-toggle="modal"
                                                data-bs-target="#edit{{ $category->id }}"><i
                                                    class="fa fa-edit"></i></button>
                                            <button class="btn btn-danger btn-sm" type="button" data-bs-toggle="modal"
                                                data-bs-target="#delete{{ $category->id }}"><i
                                                    class="fa fa-trash"></i></button>
                                        </td>
                                    </tr>

                                    <!-- Edit Modal -->
                                    <div class="modal fade modal-xl" id="edit{{ $category->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="editCategoryLabel{{ $category->id }}" aria-hidden="true">
                                        <div class="modal-dialog modal-xl" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editCategoryLabel{{ $category->id }}"
                                                        style="font-family: 'Cairo', sans-serif;">تعديل القســم</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form action="{{ route('admin.categories.update', $category->id) }}"
                                                        method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        @method('PATCH')
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">اسم القسم
                                                                (العربية)</label>
                                                            <input class="form-control" type="text" name="name_ar"
                                                                value="{{ old('name_ar', $category->getTranslation('name', 'ar')) }}"
                                                                required>
                                                            @error('name_ar')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">اسم القسم
                                                                (الإنجليزية)</label>
                                                            <input class="form-control" type="text" name="name_en"
                                                                value="{{ old('name_en', $category->getTranslation('name', 'en')) }}"
                                                                required>
                                                            @error('name_en')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                        <div class="mb-3">
                                                            <label
                                                                style="font-family: 'Cairo', sans-serif;">الصورة</label>
                                                            <input class="form-control" type="file" name="image"
                                                                accept="image/*">
                                                            @if ($category->image)
                                                            <small>الصورة الحالية: <img
                                                                    src="{{ asset('storage/' . $category->image) }}"
                                                                    width="100" alt="Current Image"></small>
                                                            @endif
                                                            @error('image')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">القسم
                                                                الرئيسي</label>
                                                            <select name="parent_id" class="form-control">
                                                                <option value="">لا يوجد قسم رئيسي</option>
                                                                @foreach ($categories as $parent)
                                                                @if ($parent->id !== $category->id)
                                                                <option value="{{ $parent->id }}" {{ old('parent_id',
                                                                    $category->parent_id) == $parent->id ? 'selected' :
                                                                    '' }}>
                                                                    {{ $parent->getTranslation('name', 'ar') }}
                                                                </option>
                                                                @endif
                                                                @endforeach
                                                            </select>
                                                            @error('parent_id')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                        <div class="mb-3">
                                                            <label
                                                                style="font-family: 'Cairo', sans-serif;">الحالة</label>
                                                            <select name="is_active" class="form-control" required>
                                                                <option value="1" {{ old('is_active', $category->
                                                                    is_active) ? 'selected' : '' }}>
                                                                    مفعل
                                                                </option>
                                                                <option value="0" {{ old('is_active', $category->
                                                                    is_active) ? '' : 'selected' }}>
                                                                    غير مفعل
                                                                </option>
                                                            </select>
                                                            @error('is_active')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button class="btn btn-secondary" type="button"
                                                                data-bs-dismiss="modal">إغلاق</button>
                                                            <button class="btn btn-primary" type="submit">حفظ</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="delete{{ $category->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="deleteCategoryLabel{{ $category->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteCategoryLabel{{ $category->id }}"
                                                        style="font-family: 'Cairo', sans-serif;">تأكيد الحذف</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    هل أنت متأكد أنك تريد حذف قسم "{{ $category->getTranslation('name',
                                                    'ar') }}"؟ هذا الإجراء لا يمكن التراجع عنه.
                                                </div>
                                                <div class="modal-footer">
                                                    <button class="btn btn-secondary" type="button"
                                                        data-bs-dismiss="modal">إلغاء</button>
                                                    <form
                                                        action="{{ route('admin.categories.destroy', $category->id) }}"
                                                        method="POST" style="display: inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button class="btn btn-danger" type="submit">حذف</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')
@endsection