@extends('admin.layouts.master')
@section('title')
الخصائص الفئات
@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">خصائص الفئات االرئيسية</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة / </a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">   خصائص الفئات
 
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            <a href="{{route('admin.filters.create')}}" class="btn btn-success btn-lg"
                                style="font-family: 'Cairo', sans-serif;">
                                أضافـــــــة خاصية جــديــد
                            </a>
                        </div>
                        <br>
                        <div class="table-responsive">
                             <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">اســــم الخاصية</th>
                                        <th style="font-family: 'Cairo', sans-serif;">اســــم الفئة المنتمي اليها</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليـــــات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($filters as $filter)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{ $i }}</td>
                                        <td>{{ $filter->getTranslation('key','ar') }}</td>
                                        <td>{{ $filter->category->getTranslation('name','ar') }}</td>

                                        
                                        <td>
                                            <button class="btn btn-success btn-sm" type="button" data-bs-toggle="modal"
                                                data-bs-target="#edit{{ $filter->id }}"><i
                                                    class="fa fa-edit"></i></button>
                                            <button class="btn btn-danger btn-sm" type="button" data-bs-toggle="modal"
                                                data-bs-target="#delete{{ $filter->id }}"><i
                                                    class="fa fa-trash"></i></button>
                                        </td>
                                    </tr>

                                    <!-- Edit Modal -->
                                   <div class="modal fade" id="edit{{ $filter->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="editfilterLabel{{ $filter->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editfilterLabel{{ $filter->id }}"
                                                        style="font-family: 'Cairo', sans-serif;">تعديل الخاصية</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                   <form action="{{ route('admin.filters.update', $filter->id) }}" method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        @method('PATCH')
                                                        
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">اسم الخاصية (العربية)</label>
                                                            <input class="form-control" type="text" name="key_ar"
                                                                value="{{ old('key_ar', $filter->getTranslation('key','ar')) }}" required>
                                                            @error('key_ar')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>

                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">اسم الخاصية (الإنجليزية)</label>
                                                            <input class="form-control" type="text" name="key_en"
                                                                value="{{ old('key_en', $filter->getTranslation('key','en')) }}" required>
                                                            @error('key_en')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                                                             <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;"> نوع البيانات (العربية)</label>
                                                            <input class="form-control"  placeholder="سم \ كم \ % \ كج ........" type="text" name="data_type_ar"
                                                                value="{{ old('key_ar', $filter->getTranslation('data_type','ar')) }}" required>
                                                            @error('key_ar')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>

                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;"> نوع البيانات  (الإنجليزية)</label>
                                                            <input class="form-control" placeholder="cm \ kg \ % \ km ........"  type="text" name="data_type_en"
                                                                value="{{ old('key_en', $filter->getTranslation('data_type','en')) }}" required>
                                                            @error('key_en')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>

                                                        <div class="col-md-3">
                                                            <label for="CategoryID" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">اسم القسم</label>
                                                            <select name="category_id" id="category_id" class="form-control" required>
                                                                <option value="" disabled>اختر القسم</option>
                                                                @foreach ($categories as $category)
                                                                    <option value="{{ $category->id }}" 
                                                                        {{ old('category_id', $filter->category_id) == $category->id ? 'selected' : '' }}>
                                                                        {{ $category->getTranslation('name','ar') }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div class="modal-footer">
                                                            <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">إغلاق</button>
                                                            <button class="btn btn-primary" type="submit">حفظ</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="delete{{ $filter->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="deletefilterLabel{{ $filter->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deletefilterLabel{{ $filter->id }}"
                                                        style="font-family: 'Cairo', sans-serif;">تأكيد الحذف</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    هل أنت متأكد أنك تريد حذف الخاصية "{{$filter->getTranslation('key','ar')
                                                    }}"؟ هذا الإجراء لا يمكن التراجع عنه.
                                                </div>
                                                <div class="modal-footer">
                                                    <button class="btn btn-secondary" type="button"
                                                        data-bs-dismiss="modal">إلغاء</button>
                                                    <form
                                                        action="{{route('admin.filters.destroy',$filter->id)}}"
                                                        method="POST" style="display: inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button class="btn btn-danger" type="submit">حذف</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table >
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')
@endsection