@extends('admin.layouts.master')

@section('title')
    تعديل كوبون
@endsection

@section('css')
    @include('admin.layouts.css')
@endsection

@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif
    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">تعديل كوبون</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.home') }}" style="font-family: 'Cairo', sans-serif;">الرئيسية</a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.coupons.index') }}" style="font-family: 'Cairo', sans-serif;">كوبونات الخصم</a>
                        </li>
                        <li class="breadcrumb-item active" style="font-family: 'Cairo', sans-serif;">تعديل كوبون</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger mx-3">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="container-fluid">
        <div class="card p-4">
            <form method="POST" action="{{ route('admin.coupons.update', $coupon->id) }}">
                @csrf
                @method('PUT')

                <div class="mb-3">
                    <label>الكود</label>
                    <input type="text" name="code" class="form-control" value="{{ old('code', $coupon->code) }}" required>
                </div>

                <div class="mb-3">
                    <label>النوع</label>
                    <select name="type" class="form-control" required>
                        <option value="fixed" {{ old('type', $coupon->type) == 'fixed' ? 'selected' : '' }}>مبلغ ثابت</option>
                        <option value="percent" {{ old('type', $coupon->type) == 'percent' ? 'selected' : '' }}>نسبة مئوية</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label>القيمة</label>
                    <input type="number" name="value" class="form-control" step="0.01" value="{{ old('value', $coupon->value) }}" required>
                </div>

                <div class="mb-3">
                    <label>أقصى عدد مرات الاستخدام (اختياري)</label>
                    <input type="number" name="max_usage" class="form-control" value="{{ old('max_usage', $coupon->max_usage) }}">
                </div>

                <div class="mb-3">
                    <label>تاريخ الانتهاء (اختياري)</label>
                    <input type="date" name="expires_at" class="form-control" value="{{ old('expires_at', $coupon->expires_at ? \Carbon\Carbon::parse($coupon->expires_at)->format('Y-m-d') : '') }}">
                </div>

                <div class="mb-3">
                    <label>الحالة</label>
                    <select name="is_active" class="form-control">
                        <option value="1" {{ old('is_active', $coupon->is_active) == 1 ? 'selected' : '' }}>مفعل</option>
                        <option value="0" {{ old('is_active', $coupon->is_active) == 0 ? 'selected' : '' }}>غير مفعل</option>
                    </select>
                </div>

                <div class="text-center">
                    <a href="{{ route('admin.coupons.index') }}" class="btn btn-secondary">إلغاء</a>
                    <button type="submit" class="btn btn-primary">تحديث</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    @include('admin.layouts.js')
@endsection
