@extends('admin.layouts.master')

@section('title')
    كوبونات الخصم
@endsection

@section('css')
    @include('admin.layouts.css')
@endsection

@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">كوبونات الخصم</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}" style="font-family: 'Cairo', sans-serif;">الرئيسية</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">كوبونات الخصم</li>
                    </ol>
                </div>
                <div class="col-sm-6 text-end">
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#couponModal" style="font-family: 'Cairo', sans-serif;">
                        إضافة كوبون جديد
                    </button>
                </div>
            </div>
        </div>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger mx-3">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card p-3">
                    <div class="table-responsive">
                        <table class="display datatables" id="dt-plugin-method">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الكود</th>
                                    <th>النوع</th>
                                    <th>القيمة</th>
                                    <th>عدد مرات الاستخدام</th>
                                    <th>انتهاء الصلاحية</th>
                                    <th>الحالة</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($coupons as $coupon)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $coupon->code }}</td>
                                        <td>{{ $coupon->type }}</td>
                                        <td>{{ $coupon->value }}</td>
                                        <td>{{ $coupon->used_count }} / {{ $coupon->max_usage ?? 'غير محدد' }}</td>
                                        <td>{{ $coupon->expires_at ? $coupon->expires_at->format('Y-m-d') : 'غير محدد' }}</td>
                                        <td>
                                            <span class="badge {{ $coupon->is_active ? 'bg-success' : 'bg-danger' }}">
                                                {{ $coupon->is_active ? 'مفعل' : 'غير مفعل' }}
                                            </span>
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.coupons.edit', $coupon->id) }}" class="btn btn-success btn-sm">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.coupons.destroy', $coupon->id) }}" method="POST" style="display: inline-block;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من الحذف؟');">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Adding Coupon -->
<div class="modal fade" id="couponModal" tabindex="-1" aria-labelledby="couponModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('admin.coupons.store') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="couponModalLabel" style="font-family: 'Cairo', sans-serif;">إضافة كوبون جديد</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label>الكود</label>
                        <input type="text" name="code" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>النوع</label>
                        <select name="type" class="form-control" required>
                            <option value="fixed">مبلغ ثابت</option>
                            <option value="percent">نسبة مئوية</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label>القيمة</label>
                        <input type="number" name="value" class="form-control" step="0.01" required>
                    </div>
                    <div class="mb-3">
                        <label>أقصى عدد مرات الاستخدام (اختياري)</label>
                        <input type="number" name="max_usage" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label>تاريخ الانتهاء (اختياري)</label>
                        <input type="date" name="expires_at" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label>الحالة</label>
                        <select name="is_active" class="form-control">
                            <option value="1">مفعل</option>
                            <option value="0">غير مفعل</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    @include('admin.layouts.js')
@endsection
