@extends('admin.layouts.master')

@section('title', 'كل طلبات القطع')

@section('css')
@include('admin.layouts.css')
@endsection

@section('body')
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>طلبات القطع</h3>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>المستخدم</th>
                                        <th>الهاتف</th>
                                        <th>الوصف</th>
                                        <th>الحالة</th>
                                        <th>العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($requests as $i => $request)
                                        <tr>
                                            <td>{{ $i + 1 }}</td>
                                            <td>{{ $request->user?->full_name }}</td>
                                            <td>{{ $request->user?->phone }}</td>
                                            <td>{{ Str::limit($request->description, 30) }}</td>
                                            <td>
                                                <span class="badge bg-{{ $request->status == 'pending' ? 'warning' : 'success' }}">
                                                    {{ $request->status }}
                                                </span>
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-info" data-bs-toggle="modal"
                                                        data-bs-target="#edit{{ $request->id }}">
                                                    تحديث تتبع الطلب 
                                                </button>

                                                <a href="{{ route('admin.custom_parts.items', $request->id) }}"
                                                   class="btn btn-sm btn-primary">
                                                    عرض العناصر
                                                </a>
                                            </td>
                                        </tr>

                                        <!-- Modal -->
                                                                           <!-- Edit Order Modal -->
                                    <div class="modal fade" id="edit{{$request->id}}" tabindex="-1"
                                        aria-labelledby="editOrderModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editOrderModalLabel">تعديل الطلب</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form enctype="multipart/form-data" method="post"
                                                        action="{{ route('admin.custom_parts.update', $request->id) }}">
                                                        @csrf
                                                        @method('PATCH')
                                                        <div class="mb-3">
                                                            <label for="editStatus" class="form-label">الحالة</label>
                                                            <select class="form-control" id="editStatus" name="status"
                                                                required>
                                                                <option value="prepared" {{ $request->status == 'prepared' ?
                                                                    'selected' : 'prepared' }}>تم التجهيز</option>
                                                                <option value="shipped" {{ $request->status == 'shipped' ?
                                                                    'selected' : 'shipped' }}>تم الشحن</option>
                                                                <option value="ended" {{ $request->status ==
                                                                    'ended' ?
                                                                    'selected' : 'ended' }}>تم التوصيل</option>
                                                                <option value="canceled" {{ $request->status == 'canceled'
                                                                    ? 'selected' : '' }}>ملغي</option>
                                                            </select>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-bs-dismiss="modal">إلغاء</button>
                                                            <button type="submit" class="btn btn-primary">حفظ
                                                                التغييرات</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> 
</div>
@endsection

@section('js')
@include('admin.layouts.js')
@endsection
