@extends('admin.layouts.master')

@section('title', 'عناصر الطلب')

@section('css')
@include('admin.layouts.css')
@endsection

@section('body')
<div class="page-body">
    <div class="container-fluid">
        <h4>عناصر الطلب رقم #{{ $request->id }}</h4>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                       <table class="table table-bordered table-striped text-center" id="itemsTable">
                            <thead class="table-dark">
                                <tr>
                                    <th style="width: 50px;">#</th>
                                    <th style="width: 25%;">الاسم</th>
                                    <th style="width: 10%;">الكمية</th>
                                    <th style="width: 30%;">ملاحظات</th>
                                    <th style="width: 15%;">العروض</th>
                                </tr>
                            </thead>
  
                            <tbody>
                                @foreach ($request->items as $i => $item)
                                <tr>
                                        <td>{{ $i + 1 }}</td>
                                        <td class="text-nowrap">{{ $item->name }}</td>
                                        <td>{{ $item->quantity }}</td>
                                        <td class="text-wrap">{{ $item->notes ?: '—' }}</td>
                                        <td>
                                            <button class="btn btn-sm btn-info" data-bs-toggle="modal"
                                                    data-bs-target="#offersModal{{ $item->id }}">
                                                عرض العروض
                                            </button>
                                        </td>
                                    </tr>

                                    <!-- Offers Modal -->
                                    <div class="modal fade" id="offersModal{{ $item->id }}" tabindex="-1">
                                        <div class="modal-dialog modal-xl">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">العروض للعنصر: {{ $item->name }}</h5>
                                                </div>
                                                <div class="modal-body">
                                                    @forelse ($item->itemOffers as $offer)
                                                        <div class="card mb-3">
                                                            <div class="card-body">
                                                                <p><strong>البائع:</strong> {{ $offer->vendor->name }}</p>
                                                                <p><strong>السعر:</strong> {{ $offer->price }}</p>
                                                                <p><strong>الضمان:</strong> {{ $offer->warranty_period }}</p>
                                                                <p><strong>الحالة:</strong>
                                                                    @if ($offer->status == 'accepted')
                                                                        <span class="badge bg-success">تم القبول</span>
                                                                    @else
                                                                        <span class="badge bg-warning">معلق</span>
                                                                    @endif
                                                                </p>

                                                                @if ($offer->status != 'accepted')
                                                                    <form method="POST" action="{{ route('admin.custom_parts.accept_offer', $offer->id) }}">
                                                                        @csrf
                                                                        <button type="submit" class="btn btn-success">قبول العرض</button>
                                                                    </form>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    @empty
                                                        <p>لا توجد عروض لهذا العنصر.</p>
                                                    @endforelse
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </tbody>
                        </table>
                        <a href="" class="btn btn-secondary mt-4">رجوع</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
@include('admin.layouts.js')
@endsection
