@extends('admin.layouts.master')
@section('title')
  فحوصات التخصصات
@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">فحوصات الاصـــــــلاح </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">الأقســام الرئيسيـــــــة
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        
                        <div>
                            <button class="btn btn-success btn-lg" type="button" data-bs-toggle="modal" data-bs-target="#addSpiclization">
                                أضافـــــــة فحص جــديــد
                            </button>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">اســــم الفحص</th>
                                        <th style="font-family: 'Cairo', sans-serif;">اســــم التخصص المنتمي الية</th>

                                        <th style="font-family: 'Cairo', sans-serif;">العمليـــــات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($inceptions as $inception)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{ $i }}</td>
                                        <td>{{ $inception->getTranslation('title', 'ar') }}</td>
                                        <td>{{ $inception->speclity?->getTranslation('title', 'ar') }}</td>
                                        <td>
                                            <button class="btn btn-success btn-sm" type="button" data-bs-toggle="modal"
                                                data-bs-target="#edit{{ $inception->id }}"><i
                                                    class="fa fa-edit"></i></button>
                                            <button class="btn btn-danger btn-sm" type="button" data-bs-toggle="modal"
                                                data-bs-target="#delete{{ $inception->id }}"><i
                                                    class="fa fa-trash"></i></button>
                                        </td>
                                    </tr>

                                    <!-- Edit Modal -->
                                    <div class="modal fade" id="edit{{ $inception->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="editCategoryLabel{{ $inception->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editCategoryLabel{{ $inception->id }}"
                                                        style="font-family: 'Cairo', sans-serif;">تعديل الفحص</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form action="{{ route('admin.inceptions.update', $inception->id) }}"
                                                        method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        @method('PATCH')
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">اسم الفحص
                                                                (العربية)</label>
                                                            <input class="form-control" type="text" name="title_ar"
                                                                value="{{ old('title_ar', $inception->getTranslation('title', 'ar')) }}"
                                                                required>
                                                            @error('title_ar')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">اسم الفحص
                                                                (الإنجليزية)</label>
                                                            <input class="form-control" type="text" name="title_en"
                                                                value="{{ old('title_en', $inception->getTranslation('title', 'en')) }}"
                                                                required>
                                                            @error('title_en')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">
                                                                التخصص الرئيسي</label>
                                                            <select name="specialty_id" class="form-control">
                                                                <option value="">   </option>
                                                                @foreach ($spiclizations as $spiclization)
                                                                @if ($spiclization->id !== $inception->id)
                                                                <option value="{{ $spiclization->id }}" {{ old('specialty_id',
                                                                    $inception->specialty_id) == $spiclization->id ? 'selected' :
                                                                    '' }}>
                                                                    {{ $spiclization->getTranslation('title', 'ar') }}
                                                                </option>
                                                                @endif
                                                                @endforeach
                                                            </select>
                                                            @error('specialty_id')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                       
                                                    
                                                        
                                                        <div class="modal-footer">
                                                            <button class="btn btn-secondary" type="button"
                                                                data-bs-dismiss="modal">إغلاق</button>
                                                            <button class="btn btn-primary" type="submit">حفظ</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="delete{{ $inception->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="deleteCategoryLabel{{ $inception->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteCategoryLabel{{ $inception->id }}"
                                                        style="font-family: 'Cairo', sans-serif;">تأكيد الحذف</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    هل أنت متأكد أنك تريد حذف الفحص "{{ $inception->getTranslation('title',
                                                    'ar') }}"؟ هذا الإجراء لا يمكن التراجع عنه.
                                                </div>
                                                <div class="modal-footer">
                                                    <button class="btn btn-secondary" type="button"
                                                        data-bs-dismiss="modal">إلغاء</button>
                                                    <form
                                                        action="{{ route('admin.inceptions.destroy', $inception->id) }}"
                                                        method="POST" style="display: inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button class="btn btn-danger" type="submit">حذف</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>

                            <!-- Add Modal -->
                            <div class="modal fade" id="addSpiclization" tabindex="-1" role="dialog" aria-labelledby="addSpiclizationLabel" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="addSpiclizationLabel" style="font-family: 'Cairo', sans-serif;">إضافة فحص جديد</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                                        </div>
                                        <div class="modal-body">
                                            <form action="{{ route('admin.inceptions.store') }}" method="POST" enctype="multipart/form-data">
                                                @csrf
                                                <div class="mb-3">
                                                    <label style="font-family: 'Cairo', sans-serif;">اسم الفحص (العربية)</label>
                                                    <input class="form-control" type="text" name="title_ar" value="{{ old('title_ar') }}" required>
                                                    @error('title_ar')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <div class="mb-3">
                                                    <label style="font-family: 'Cairo', sans-serif;">اسم الفحص (الإنجليزية)</label>
                                                    <input class="form-control" type="text" name="title_en" value="{{ old('title_en') }}" required>
                                                    @error('title_en')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">
                                                                التخصص الرئيسي</label>
                                                            <select name="specialty_id" class="form-control" required>
                                                                <option value=""> اختر التخصص الرئيسي  </option>
                                                                @foreach ($spiclizations as $spiclization)
                                                                @if ($spiclization->id !== $inception->id)
                                                                <option value="{{ $spiclization->id }}">
                                                                    {{ $spiclization->getTranslation('title', 'ar') }}
                                                                </option>
                                                                @endif
                                                                @endforeach
                                                            </select>
                                                            @error('parent_id')
                                                            <span class="text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>

                                                <div class="modal-footer">
                                                    <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">إغلاق</button>
                                                    <button class="btn btn-primary" type="submit">حفظ</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')
@endsection