@extends('admin.layouts.master')

@section('title','مكتبة الوسائط')

@section('css')
@include('admin.layouts.css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/min/dropzone.min.css">
@endsection

@section('body')
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

@if(session('success'))<script>toastr.success("{{ session('success') }}");</script>@endif
@if(session('error'))<script>toastr.error("{{ session('error') }}");</script>@endif

<div class="page-body">
  <div class="container-fluid">
    <div class="page-header">
      <div class="row">
        <div class="col-sm-6">
          <h3 style="font-family:'Cairo',sans-serif;">مكتبة الوسائط</h3>
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">الرئيسية</a></li>
            <li class="breadcrumb-item active">الوسائط</li>
          </ol>
        </div>
      </div>
    </div>
  </div>

  <div class="container-fluid">
    <div class="card">
      <div class="card-body">

        {{-- ✅ Multi Upload --}}
        <h5 class="mb-3">رفع صور جديدة</h5>
        <form action="{{ route('admin.media.upload') }}" 
              method="POST" class="dropzone" id="mediaDropzone">
            @csrf
            <div class="dz-message">اسحب الصور هنا أو اضغط للاختيار</div>
        </form>
        <hr>

        {{-- ✅ Existing Images --}}
        <h5 class="mb-3">الصور المرفوعة</h5>
        <div class="d-flex overflow-auto py-3" style="gap: 1rem;">
            @foreach($files as $url)
            <div class="card" style="min-width: 200px; flex: 0 0 auto;">
                <img src="{{ asset('storage/'.$url)}}" class="card-img-top" 
                    style="height:180px; object-fit:cover; cursor:pointer;"
                    onclick="selectImage('{{ $url }}')">
                <div class="card-body text-center p-2">
                    <small>{{ basename($url) }}</small>
                </div>
            </div>
            @endforeach
        </div>

        {{-- ✅ Selected Image URL --}}
      <div class="mt-3">
            <label>الرابط المختار:</label>
            <div class="input-group">
                <input type="text" id="selectedImage" class="form-control" readonly>
                <button class="btn btn-outline-secondary" type="button" onclick="copyLink()">نسخ</button>
            </div>
        </div>

      </div>
    </div>
  </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/min/dropzone.min.js"></script>
<script>
Dropzone.options.mediaDropzone = {
    paramName: 'images', // ✅ صح
    uploadMultiple: true,
    parallelUploads: 10,
    maxFilesize: 2, // MB
    acceptedFiles: 'image/*',
    success: function(file, response) {
        toastr.success('تم رفع ' + response.urls.length + ' صورة');
        setTimeout(() => location.reload(), 800);
    },
    error: function(file, response) {
        toastr.error('حدث خطأ أثناء رفع الصور');
        console.error(response);
    }
};

function selectImage(url){
    $('#selectedImage').val(url);
    toastr.info('تم نسخ الرابط ، انسخه للاستخدام');
}
function copyLink() {
    const input = document.getElementById("selectedImage");
    if (!input.value) {
        toastr.warning("لا يوجد رابط للنسخ");
        return;
    }

    input.select();
    input.setSelectionRange(0, 99999); // للهواتف
    document.execCommand("copy");

    toastr.success("تم نسخ الرابط");
}
</script>
@endsection

@section('js')
@include('admin.layouts.js')
@endsection
