@extends('admin.layouts.master')
@section('title')
تعديل تاجر
@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.merchant.index') }}">التجار</a></li>
                        <li class="breadcrumb-item">تعديل تاجر</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="bookmark"></div>
                </div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 style="font-family: 'Cairo', sans-serif;">تعديـــل تاجــر</h5>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" novalidate enctype="multipart/form-data" method="POST"
                            action="{{ route('admin.merchant.update', $merchant->id) }}">
                            @csrf
                            @method('PATCH')
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">اسم التاجر (عربي)</label>
                                    <input name="name_ar" class="form-control" type="text"
                                        value="{{ old('name_ar', $merchant->getTranslation('name', 'ar')) }}" required>
                                    @error('name_ar')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">اسم التاجر (إنجليزي)</label>
                                    <input name="name_en" class="form-control" type="text"
                                        value="{{ old('name_en', $merchant->getTranslation('name', 'en')) }}" required>
                                    @error('name_en')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">البريد الإلكتروني</label>
                                    <input name="email" class="form-control" type="email"
                                        value="{{ old('email', $merchant->email) }}" required>
                                    @error('email')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">كلمة المرور (اتركها فارغة لعدم
                                        التغيير)</label>
                                    <input name="password" class="form-control" type="password">
                                    @error('password')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">تأكيد كلمة المرور</label>
                                    <input name="password_confirmation" class="form-control" type="password">
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">رقم الهاتف</label>
                                    <input name="phone" class="form-control" type="text"
                                        value="{{ old('phone', $merchant->phone) }}" required>
                                    @error('phone')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="row g-3 mt-3">
                                    <div class="col-md-6">
                                        <label style="font-family: 'Cairo', sans-serif;">المحافظة</label>
                                        <select name="governorate_id" id="governorate" class="form-control" required>
                                            <option value="" disabled selected>اختر المحافظة</option>
                                            @foreach ($governates as $governorate)
                                                <option value="{{ $governorate->id }}"
                                                    {{ old('governorate_id', $merchant->city->governorate_id ?? '') == $governorate->id ? 'selected' : '' }}>
                                                    {{ $governorate->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('governorate_id')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-md-6">
                                        <label style="font-family: 'Cairo', sans-serif;">المدينة</label>
                                        <select name="city_id" id="city" class="form-control" required>
                                            <option value="" disabled selected>اختر المدينة</option>
                                            @foreach ($cities as $city)
                                                <option value="{{ $city->id }}"
                                                    data-governorate="{{ $city->governorate_id }}"
                                                    {{ old('city_id', $merchant->city_id) == $city->id ? 'selected' : '' }}>
                                                    {{ $city->name['ar'] }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('city_id')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">العنوان</label>
                                    <input name="address" class="form-control" type="text"
                                        value="{{ old('address', $merchant->address) }}" required>
                                    @error('address')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">الصورة</label>
                                    <input name="image" class="form-control" type="file" accept="image/*">
                                    @if ($merchant->image)
                                    <small>الصورة الحالية: <img src="{{ asset('storage/' . $merchant->image) }}"
                                            width="100" alt="Current Image"></small>
                                    @endif
                                    @error('image')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">الوصف</label>
                                    <textarea name="description"
                                        class="form-control">{{ old('description', $merchant->description) }}</textarea>
                                    @error('description')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">الحالة</label>
                                    <select name="is_active" class="form-control" required>
                                        <option value="1" {{ old('is_active', $merchant->is_active) == 1 ? 'selected' :
                                            '' }}>مفعل</option>
                                        <option value="0" {{ old('is_active', $merchant->is_active) == 0 ? 'selected' :
                                            '' }}>غير مفعل</option>
                                    </select>
                                    @error('is_active')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary"
                                        style="font-family: 'Cairo', sans-serif;">حفظ التغييرات</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')
@endsection