@extends('admin.layouts.master')
@section('title')
التجار
@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">التجــــــار</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item">التجار</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <a href="{{ route('admin.merchant.create') }}" class="btn btn-success btn-lg"
                        style="font-family: 'Cairo', sans-serif;">إضافة تاجر جديد</a>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                         <form id="bulkDeleteForm" method="post" action="{{route('admin.merchant.bulk_delete')}}">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger mb-3">حذف المحددين</button>
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                         <th><input type="checkbox" id="selectAll"></th> <!-- Select All -->
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الاسم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">البريد الإلكتروني</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الهاتف</th>
                                        <th style="font-family: 'Cairo', sans-serif;">المدينة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الصورة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الحالة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($merchants as $merchant)
                                    <tr>
                                        <td><input type="checkbox" name="merchant_ids[]" value="{{ $merchant->id }}"></td>
                                        <?php $i++; ?>

                                        <td>{{ $i }}</td>
                                        <td>{{ $merchant->getTranslation('name', 'ar') }}</td>
                                        <td>{{ $merchant->email }}</td>
                                        <td>{{ $merchant->phone }}</td>
                                        <td>{{ $merchant->city ? $merchant->city->name['ar'] : 'غير محدد' }}</td>
                                        <td>
                                            @if ($merchant->image)
                                            <img width="100" src="{{ asset('storage/' . $merchant->image) }}"
                                                alt="Merchant Image">
                                            @else
                                            <span>لا توجد صورة</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span
                                                class="badge {{ $merchant->is_active ? 'badge-success' : 'badge-danger' }}">
                                                {{ $merchant->is_active ? 'مفعل' : 'غير مفعل' }}
                                            </span>
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.merchant.edit', $merchant->id) }}"
                                                class="btn btn-success btn-sm"><i class="fa fa-edit"></i></a>
                                             <!-- Button trigger modal -->
                                           

                                            <!-- Delete Form -->
                                            <button class="btn btn-danger" data-bs-toggle="modal"
                                                data-bs-target="#deleteModal{{ $merchant->id }}">
                                                <i class="fa fa-remove"></i> حذف
                                            </button>
                                        </td>
                                    </tr>
                                     <div class="modal fade" id="deleteModal{{ $merchant->id }}" tabindex="-1"
                                        aria-labelledby="deleteModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteModalLabel">حذف مقدم الخدمة</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="إغلاق"></button>
                                                </div>
                                                <div class="modal-body">
                                                    هل أنت متأكد أنك تريد حذف مقدم الخدمة هذا ؟
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">إلغاء</button>
                                                    <form action="{{ route('admin.merchant.destroy', $merchant->id) }}"
                                                        method="post" style="display:inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger">حذف</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                          </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')
<script>
    $('#selectAll').click(function() {
        $('input[name="merchant_ids[]"]').prop('checked', this.checked);
    });
</script>
@endsection