@extends('admin.layouts.master')
@section('title')
الإشعارات
@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif
    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">الإشعــارات</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item">الإشعارات</li>
                    </ol>
                </div>
                <div class="col-sm-6 text-end">
                    @php
                    $unreadCount = auth()->user()->notifications()->where('is_read', 0)->count();
                    @endphp
                    @if ($unreadCount > 0)
                    <form action="{{ route('admin.notifications.markAllAsRead') }}" method="POST"
                        style="display: inline;">
                        @csrf
                        <button type="submit" class="btn btn-primary" style="font-family: 'Cairo', sans-serif;">
                            تحديد الكل كمقروء
                        </button>
                    </form>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العنوان</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الرسالة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">النوع</th>
                                        <th style="font-family: 'Cairo', sans-serif;">مرتبط بـ</th>
                                        <th style="font-family: 'Cairo', sans-serif;">التاريخ</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الحالة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($notifications as $notification)
                                    <tr class="{{ $notification->is_read ? '' : 'bg-light' }}">
                                        <?php $i++; ?>
                                        <td>{{ $i }}</td>
                                        <td>{{ $notification->title }}</td>
                                        <td>{{ Str::limit($notification->message, 100) }}</td>
                                        <td>{{ $notification->type }}</td>
                                        <td>
                                            @if ($notification->related)
                                            @php
                                            $relatedRoute = '';
                                            if ($notification->related_type === 'App\\Models\\Order') {
                                            $relatedRoute = route('admin.orders.show', $notification->related_id);
                                            } elseif ($notification->related_type === 'App\\Models\\TowRequest') {
                                            $relatedRoute = route('admin.tow-requests.show', $notification->related_id);
                                            }
                                            @endphp
                                            @if ($relatedRoute)
                                            <a href="{{ $relatedRoute }}" class="text-primary"
                                                style="font-family: 'Cairo', sans-serif;">
                                                عرض التفاصيل
                                            </a>
                                            @else
                                            <span>غير متوفر</span>
                                            @endif
                                            @else
                                            <span>غير مرتبط</span>
                                            @endif
                                        </td>
                                        <td>{{ $notification->created_at->diffForHumans() }}</td>
                                        <td>
                                            <span
                                                class="badge {{ $notification->is_read ? 'badge-success' : 'badge-danger' }}">
                                                {{ $notification->is_read ? 'مقروء' : 'غير مقروء' }}
                                            </span>
                                        </td>
                                        <td>
                                            @if (!$notification->is_read)
                                            <button class="btn btn-sm btn-primary mark-as-read"
                                                data-id="{{ $notification->id }}"
                                                style="font-family: 'Cairo', sans-serif;">
                                                <i class="fa fa-check"></i> تحديد كمقروء
                                            </button>
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            {{ $notifications->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')
<script>
    $(document).ready(function() {
            $('#dt-plugin-method').DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json'
                },
                pageLength: 10,
                searching: true,
                ordering: true
            });

            $('.mark-as-read').on('click', function() {
                const notificationId = $(this).data('id');
                $.ajax({
                    url: '{{ url("admin/notifications") }}/' + notificationId + '/read',
                    method: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.message);
                            setTimeout(() => location.reload(), 1000);
                        } else {
                            toastr.error(response.message);
                        }
                    },
                    error: function() {
                        toastr.error('حدث خطأ. حاول مرة أخرى.');
                    }
                });
            });
        });
</script>
@endsection